/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.definitions;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.HistoryProviderDelegate;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.definitions.CPSMNoGroupDefinition;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ApplicationDefinition
extends CPSMNoGroupDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private HistoryProviderDelegate historyProviderDelegate;

    protected ApplicationDefinition(Configuration configuration, Map<String, String> attributes, boolean skinny) {
        super(configuration, attributes, skinny);
    }

    @Override
    public boolean equals(Object anObject) {
        if (anObject instanceof ApplicationDefinition) {
            ApplicationDefinition anotherDefinition = (ApplicationDefinition)anObject;
            return this.getAttributes().get("ALIAS").equals(anotherDefinition.getAttributes().get("ALIAS"));
        }
        return false;
    }

    @Override
    public IHistoryProvider getIHistoryProvider() {
        if (this.historyProviderDelegate == null) {
            this.historyProviderDelegate = new HistoryProviderDelegate(this){

                @Override
                protected List<RestrictionCriteria> getAdditionalCriteria() {
                    ArrayList<RestrictionCriteria> arrayList = new ArrayList<RestrictionCriteria>();
                    arrayList.add(new RestrictionCriteria("JNLOBJNAME", FilterExpression.Operator.EQ, ApplicationDefinition.this.getAttributes().get("ALIAS")));
                    arrayList.add(new RestrictionCriteria("B_CHANGETIME", FilterExpression.Operator.EQ, "*"));
                    arrayList.add(new RestrictionCriteria("A_CHANGETIME", FilterExpression.Operator.EQ, "*"));
                    return arrayList;
                }

                @Override
                protected JournalCriteria getJournalCriteria() {
                    return JournalCriteria.newJournalCriteriaForDefinition(this.getConfiguration().getName(), "", ApplicationDefinition.this.type, ApplicationDefinition.this.getAttributes().get("ALIAS"));
                }

                @Override
                protected JournalCriteria getJournalEventCriteria() {
                    return JournalCriteria.newJournalEventCriteriaForDefinition(this.getConfiguration().getName(), "", ApplicationDefinition.this.type, ApplicationDefinition.this.getAttributes().get("ALIAS"));
                }

                @Override
                protected ICMObject getObject(Map<String, String> attributes) {
                    return new History(this, attributes);
                }
            };
        }
        return this.historyProviderDelegate;
    }
}

