/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.builder;

import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.ZfsDefinition;
import com.ibm.cics.cm.model.builder.ObjectBuilder;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.InquireMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import java.util.Map;

public class ZfsDefinitionBuilder
extends ObjectBuilder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MessageResponse lastMessageResponse = null;
    private static ConfigurationManager.CMObjectFactory zfsDefinitionObjectFactory;
    private String configName;

    public ZfsDefinitionBuilder(String name, String description, String configName, String relativePath) {
        this.setName(name);
        this.setAttribute("DESCRIPTION", description);
        this.configName = configName;
        this.setAttribute("RELPATH", relativePath);
        this.setAttribute("DATA1", "");
        this.setAttribute("DATA2", "");
        this.setAttribute("DATA3", "");
        this.setAttribute("DATA4", "");
    }

    public void setData1(String data) {
        this.setAttribute("DATA1", data);
    }

    public void setData2(String data) {
        this.setAttribute("DATA2", data);
    }

    public void setData3(String data) {
        this.setAttribute("DATA3", data);
    }

    public void setData4(String data) {
        this.setAttribute("DATA4", data);
    }

    public static ConfigurationManager.CMObjectFactory getObjectFactory() {
        if (zfsDefinitionObjectFactory == null) {
            zfsDefinitionObjectFactory = new ConfigurationManager.CMObjectFactory(){

                @Override
                public ICMObject createObject(Map<String, String> attributes) {
                    return ZfsDefinition.getNewZfsDefinition(attributes);
                }
            };
        }
        return zfsDefinitionObjectFactory;
    }

    @Override
    public String getType() {
        return "ZFSFILE";
    }

    @Override
    public ZfsDefinition create(ConfigurationManager aConfigurationManager) throws CMServerException {
        MessageResponse messageResponse;
        block4: {
            this.lastMessageResponse = null;
            try {
                messageResponse = aConfigurationManager.create(this.getLocationCriteria(), this.getObjectCriteria(), this.getObjectData());
            }
            catch (CMServerException e) {
                messageResponse = e.getMessageResponse();
                if (messageResponse.returnCode != 8) break block4;
                throw e;
            }
        }
        if (messageResponse != null) {
            if (messageResponse.returnCode <= 4 && messageResponse instanceof InquireMessageResponse) {
                this.lastMessageResponse = messageResponse;
                return (ZfsDefinition)ZfsDefinitionBuilder.getObjectFactory().createObject(((InquireMessageResponse)messageResponse).getObject());
            }
            this.lastMessageResponse = messageResponse;
        }
        return null;
    }

    @Override
    public LocationCriteria getLocationCriteria() {
        if (this.locationCriteria == null) {
            this.locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.configName);
        }
        return this.locationCriteria;
    }
}

