/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.builder;

import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.MigrationPath;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.TransformationVariable;
import com.ibm.cics.cm.model.builder.ObjectBuilder;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.InquireMessageResponse;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.model.runtime.MigrationSchemeObjectData;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ObjectData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MigrationSchemeBuilder
extends ObjectBuilder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static ConfigurationManager.CMObjectFactory migrationSchemeObjectFactory;
    private ArrayList<MigrationPath> migrationPaths;
    private ArrayList<TransformationVariable> transformationVariables;

    @Override
    public String getType() {
        return "SCHEME";
    }

    public void setApproval(boolean approvalRequired) {
        this.setAttribute("APPOPTION", approvalRequired ? "YES" : "NO");
    }

    public void setMigrationPaths(ArrayList<MigrationPath> migrationPaths) {
        this.migrationPaths = migrationPaths;
    }

    public void setTransformationVariables(ArrayList<TransformationVariable> transformationVariables) {
        this.transformationVariables = transformationVariables;
    }

    public List<MigrationPath> getMigrationPaths() {
        return this.migrationPaths;
    }

    @Override
    public MigrationScheme create(ConfigurationManager aConfigurationManager) {
        MessageResponse messageResponse;
        try {
            messageResponse = aConfigurationManager.create(this.getLocationCriteria(), this.getObjectCriteria(), this.getObjectData());
        }
        catch (CMServerException e) {
            messageResponse = e.getMessageResponse();
        }
        if (messageResponse != null) {
            return (MigrationScheme)MigrationSchemeBuilder.getObjectFactory().createObject(((InquireMessageResponse)messageResponse).getObject());
        }
        return null;
    }

    public static ConfigurationManager.CMObjectFactory getObjectFactory() {
        if (migrationSchemeObjectFactory == null) {
            migrationSchemeObjectFactory = new ConfigurationManager.CMObjectFactory(){

                @Override
                public ICMObject createObject(Map<String, String> attributes) {
                    return new MigrationScheme(attributes);
                }
            };
        }
        return migrationSchemeObjectFactory;
    }

    @Override
    public ObjectCriteria getObjectCriteria() {
        if (this.objectCriteria == null) {
            this.objectCriteria = ObjectCriteria.newMigrationSchemeCriteria();
            this.objectCriteria.setObjectName(this.getName());
            this.objectCriteria.setObjectType("SCHEME");
            this.objectCriteria.setScheme(this.getName());
        }
        return this.objectCriteria;
    }

    @Override
    public ObjectData getObjectData() {
        if (this.objectData == null || !(this.objectData instanceof MigrationSchemeObjectData)) {
            this.objectData = new MigrationSchemeObjectData();
        }
        this.objectData.setAttributes(this.attributes);
        ((MigrationSchemeObjectData)this.objectData).setMigrationPaths(this.migrationPaths);
        ((MigrationSchemeObjectData)this.objectData).setTransformationVariables(this.transformationVariables);
        return this.objectData;
    }

    public MessageResponse update(ConfigurationManager current, String integrityToken) {
        MessageResponse mr = null;
        try {
            mr = ConfigurationManager.getCurrent().update(this.getLocationCriteria(), this.getObjectCriteria(), this.getObjectData(), integrityToken);
        }
        catch (CMServerException cMServerException) {
            // empty catch block
        }
        return mr;
    }
}

