/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.Configuration;
import java.util.Map;
import java.util.logging.Logger;

public class ZfsConfiguration
extends Configuration {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Logger logger = Logger.getLogger("com.ibm.cics.cm.model");

    public ZfsConfiguration(Map<String, String> attributes) {
        super(attributes);
    }

    public String getZfsRootDir() {
        return this.getAttributes().get("ZROOTDIR");
    }

    public void setZfsRootDir(String dir) {
        this.getAttributes().put("ZROOTDIR", dir);
    }

    public boolean getZfsBackup() {
        return "DIR".equals(this.getAttributes().get("ZBKUPTYPE"));
    }

    public void setZfsBackup(boolean backup) {
        this.getAttributes().put("ZBKUPTYPE", backup ? "DIR" : "NONE");
    }

    public int getZfsBackupCount() {
        return Integer.parseInt(this.getAttributes().get("ZBKUPCOUNT"));
    }

    public void setZfsBackupCount(int count) {
        this.getAttributes().put("ZBKUPCOUNT", String.valueOf(count));
    }

    public String getZfsBackupDir() {
        return this.getAttributes().get("ZBKUPDIR");
    }

    public void setZfsBackupDir(String dir) {
        this.getAttributes().put("ZBKUPDIR", dir);
    }
}

