/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.comm.CMConnectionRecord;
import com.ibm.cics.cm.comm.CMConstants;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.model.ICICSType;
import java.util.HashMap;
import java.util.Map;

public class TypeOverrides
implements CMConnectionRecord.Overrides,
Constants,
CMConstants {
    static final String COPYRIGHT = "Copyright IBM Corp. 2011, 2025.";
    private static Map<String, TypeOverrides> overidesByType = new HashMap<String, TypeOverrides>();
    private static Map<String, Integer> typeAndRelease = new HashMap<String, Integer>();
    private static Object currentRelease;
    private Map<String, Integer> attributeAndRelease = new HashMap<String, Integer>();
    private int release;

    static {
        ICICSType[] iCICSTypeArray = CICSTypes.values();
        int n = iCICSTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICICSType cicsType = iCICSTypeArray[n2];
            if (cicsType.isDefinition()) {
                TypeOverrides.putOverrides(cicsType.getResourceTableName(), new TypeOverrides("CHANGEAGENT", 410));
                TypeOverrides.addOverrides(cicsType.getResourceTableName(), "CHANGEUSRID", 410);
                TypeOverrides.addOverrides(cicsType.getResourceTableName(), "CHANGEAGREL", 410);
                TypeOverrides.addOverrides(cicsType.getResourceTableName(), "CREATETIME", 410);
                TypeOverrides.addOverrides(cicsType.getResourceTableName(), "CSDGROUP", -1);
            }
            ++n2;
        }
        TypeOverrides.addOverrides("PIPEDEF", "RESPWAIT", 320);
        TypeOverrides.addOverrides("PIPEDEF", "POLICYDIR", 320);
        TypeOverrides.addOverrides("TCPDEF", "REALM", 320);
        TypeOverrides.addOverrides("TCPDEF", "CIPHERS", 310);
        TypeOverrides.addOverrides("TCPDEF", "MAXDATALEN", 310);
        TypeOverrides.addOverrides("TCPDEF", "MAXPERSIST", 420);
        TypeOverrides.addOverrides("TCPDEF", "SPECIFTCPS", 520);
        TypeOverrides.addOverrides("DOCDEF", "HFSFILE", 310);
        TypeOverrides.addOverrides("PROGDEF", "API", 310);
        TypeOverrides.addOverrides("EJCODEF", "SSL", -1);
        TypeOverrides.addOverrides("EJCODEF", "SSLPORT", -1);
        TypeOverrides.addOverrides("EJCODEF", "PORT", -1);
        TypeOverrides.addOverrides("IPCONDEF", "IDPROP", 410);
        TypeOverrides.addOverrides("IPCONDEF", "MIRRORLIFE", 420);
        TypeOverrides.addOverrides("IPCONDEF", "FSFCREQ", 420);
        TypeOverrides.addOverrides("IPCONDEF", "FSFCSNT", 420);
        TypeOverrides.addOverrides("IPCONDEF", "FSFCRCV", 420);
        TypeOverrides.addOverrides("IPCONDEF", "HA", 520);
        TypeOverrides.addOverrides("TCPDEF", "HOST", -1);
        TypeOverrides.addOverrides("TDQDEF", "TERMID", -1);
        TypeOverrides.addOverrides("TDQDEF", "JOBUSERID", 550);
        TypeOverrides.addOverrides("TERMDEF", "ASSOCPRNTR", -1);
        TypeOverrides.addOverrides("TERMDEF", "BINDPASSWORD", -1);
        TypeOverrides.addOverrides("WEBSVDEF", "POLICYDIR", -1);
        TypeOverrides.addOverrides("WEBSVDEF", "ARCHIVEFILE", 420);
        TypeOverrides.addOverrides("URIMPDEF", "PORT", 410);
        TypeOverrides.addOverrides("URIMPDEF", "ATOMSERVICE", 410);
        TypeOverrides.addOverrides("URIMPDEF", "AUTHENTICATE", 410);
        TypeOverrides.addOverrides("URIMPDEF", "SOCKETCLOSE", 420);
        TypeOverrides.addOverrides("TSMDEF", "EXPIRYINT", 420);
        TypeOverrides.addOverrides("TSMDEF", "EXPIRYINTMIN", 520);
        TypeOverrides.addOverrides("DB2CDEF", "REUSELIMIT", 420);
        TypeOverrides.addOverrides("PROGDEF", "JVMSERVER", 420);
        TypeOverrides.addOverrides("DB2EDEF", "SHARELOCKS", 610);
        TypeOverrides.addOverrides("TRNCLDEF", "PURGEACTION", 620);
        TypeOverrides.addOverrides("CSYSDEF", "AINSMODE", 630);
        TypeOverrides.addOverrides("TRANDEF", "OTELEMIT", 630);
        TypeOverrides.addOverrides("TRANDEF", "OTELPROP", 630);
        TypeOverrides.addOverrides("URIMPDEF", "ATTLS", 630);
        TypeOverrides.addTypeOverrides("LIBDEF", 320);
        TypeOverrides.addTypeOverrides("IPCONDEF", 320);
        TypeOverrides.addTypeOverrides("BUNDDEF", 410);
        TypeOverrides.addTypeOverrides("MQCONDEF", 410);
        TypeOverrides.addTypeOverrides("ATOMDEF", 410);
        TypeOverrides.addTypeOverrides("JVMSVDEF", 410);
        TypeOverrides.addTypeOverrides("CSYSDEF", 520);
        TypeOverrides.addTypeOverrides("CSYSGRP", 520);
        TypeOverrides.addTypeOverrides("CSGLCGCS", 520);
        TypeOverrides.addTypeOverrides("CSGLCGCG", 520);
        TypeOverrides.addTypeOverrides("PERIODEF", 520);
        TypeOverrides.addTypeOverrides("CPLEXDEF", -1);
        TypeOverrides.addTypeOverrides("EPADAPT", -1);
        TypeOverrides.addTypeOverrides("CMTCMDEF", -1);
        TypeOverrides.addTypeOverrides("SYSPARM", -1);
        TypeOverrides.addTypeOverrides("EVCSDATA", -1);
        TypeOverrides.addTypeOverrides("EVCSINFO", -1);
        TypeOverrides.addTypeOverrides("EVCSOPT", -1);
        TypeOverrides.addTypeOverrides("WLMSPEC", 520);
        TypeOverrides.addTypeOverrides("WLMGROUP", 520);
        TypeOverrides.addTypeOverrides("WLMDEF", 520);
        TypeOverrides.addTypeOverrides("TRANGRP", 520);
        TypeOverrides.addTypeOverrides("LNKSWSCS", 520);
        TypeOverrides.addTypeOverrides("LNKSWSCG", 520);
        TypeOverrides.addTypeOverrides("WLMINSPC", 520);
        TypeOverrides.addTypeOverrides("WLMINGRP", 520);
        TypeOverrides.addTypeOverrides("DTRINGRP", 520);
        TypeOverrides.addTypeOverrides("APPLDEF", 510);
        TypeOverrides.addTypeOverrides("PLATDEF", 510);
        TypeOverrides.addTypeOverrides("MQMONDEF", 540);
    }

    public static TypeOverrides getOverrides(String resourceType) {
        return overidesByType.get(resourceType);
    }

    private static void addTypeOverrides(String type, int fromRelease) {
        typeAndRelease.put(type, fromRelease);
    }

    private static void addOverrides(String type, String attributeName, int fromRelease) {
        TypeOverrides.getOverrides(type).addAttributeName(attributeName, fromRelease);
    }

    static void putOverrides(String typeName, TypeOverrides aReleaseOverride) {
        overidesByType.put(typeName, aReleaseOverride);
    }

    public static Integer get(String resourceTableName) {
        return typeAndRelease.get(resourceTableName);
    }

    public static void setConnectionReleaseNumber(int release, int cmRelease) {
        if (cmRelease < 210 && release >= 410) {
            release = 320;
        }
        currentRelease = release;
        for (TypeOverrides typeOverride : overidesByType.values()) {
            typeOverride.setReleaseThreshold(release);
        }
    }

    public TypeOverrides(String attributeName, int fromRelease) {
        this.addAttributeName(attributeName, fromRelease);
    }

    public String getCMAttribute(String attributeName) {
        String override = this.getOverride(attributeName);
        if (override != null) {
            attributeName = null;
        }
        return attributeName;
    }

    public String getOverride(String attributeName) {
        Integer fromRelease = this.attributeAndRelease.get(attributeName);
        if (fromRelease != null && (fromRelease > this.release || fromRelease < 0)) {
            return "FORCE_ATTRIBUTE_UNSUPPORTED";
        }
        return null;
    }

    private void setReleaseThreshold(int release) {
        this.release = release;
    }

    public void addAttributeName(String attributeName, int fromRelease) {
        this.attributeAndRelease.put(attributeName, fromRelease);
    }
}

