/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.PackageSchemeEvent;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import java.util.List;
import java.util.Map;

public class PackageScheme
extends CMObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String cpid = null;
    private String schemeName = null;
    private int version = 0;
    private boolean skinny = true;

    public PackageScheme(Map<String, String> anAttributesMap) {
        super(anAttributesMap);
        Integer integer;
        this.cpid = anAttributesMap.get("CPID");
        this.schemeName = anAttributesMap.get("SCHEME");
        if (anAttributesMap.containsKey("VER") && (integer = Integer.getInteger(anAttributesMap.get("VER"))) != null) {
            this.version = integer;
        }
        if (anAttributesMap.containsKey("CRCCRC")) {
            this.skinny = false;
        }
    }

    private boolean ensureFullObject() {
        if (this.skinny) {
            PackageScheme fullFat = ConfigurationManager.getCurrent().inquirePackageScheme(this.cpid, this.schemeName);
            this.attributes = fullFat.attributes;
            this.skinny = false;
        }
        return !this.skinny;
    }

    public List<PackageSchemeEvent> getEvents() {
        this.ensureFullObject();
        return PackageSchemeEvent.getEvents(this, this.attributes);
    }
}

