/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.IMutableCMObject;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ObjectData;
import java.util.HashMap;
import java.util.Map;

public abstract class MutableCMObject
implements IMutableCMObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected ConfigurationManager configurationManager;
    private ObjectCriteria objectCriteria;
    private LocationCriteria locationCriteria;
    private ObjectData objectData;
    protected CMObject cmObject;

    protected MutableCMObject(ConfigurationManager aConfigurationManager, CMObject aCMObject) {
        this.configurationManager = aConfigurationManager;
        this.cmObject = aCMObject;
    }

    protected MutableCMObject(ConfigurationManager aConfigurationManager, CMObject aCMObject, ObjectCriteria anObjectCriteria) {
        this(aConfigurationManager, aCMObject);
        this.setObjectCriteria(anObjectCriteria);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getAttributeValue(String key) {
        String value = this.attributes.get(key);
        if (value == null) {
            return this.cmObject.getAttributes().get(key);
        }
        return value;
    }

    public void setDescription(String string) {
        this.attributes.put("DESCRIPTION", string);
    }

    @Override
    public String getDescription() {
        return this.attributes.get("DESCRIPTION");
    }

    @Override
    public String getIntegrityToken() {
        return this.cmObject.getAttributes().get("INTEGRITYTOKEN");
    }

    protected void setObjectCriteria(ObjectCriteria anObjectCriteria) {
        this.objectCriteria = anObjectCriteria;
        this.objectCriteria.setObjectName(this.getName());
        this.objectCriteria.setObjectType(this.getObjectType());
    }

    @Override
    public String getName() {
        return this.cmObject.getName();
    }

    @Override
    public boolean delete() throws CMServerException {
        return this.configurationManager.delete(this.getLocationCriteria(), this.getObjectCriteria());
    }

    public void commit() throws CMServerException {
        this.configurationManager.update(this.getLocationCriteria(), this.getObjectCriteria(), this.getObjectData(), this.getIntegrityToken());
    }

    protected ObjectCriteria getObjectCriteria() {
        if (this.objectCriteria == null) {
            this.setObjectCriteria(new ObjectCriteria());
        }
        return this.objectCriteria;
    }

    protected LocationCriteria getLocationCriteria() {
        if (this.locationCriteria == null) {
            this.locationCriteria = LocationCriteria.newRepositoryLocationCriteria();
        }
        return this.locationCriteria;
    }

    protected ObjectData getObjectData() {
        if (this.objectData == null) {
            this.objectData = new ObjectData();
            for (Map.Entry<String, String> next : this.getAttributes().entrySet()) {
                this.objectData.setAttribute(next.getKey(), next.getValue());
            }
        }
        return this.objectData;
    }
}

