/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.FilteredCollection;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.IHistoryCompatible;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.runtime.CMListFactory;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.model.runtime.RestrictionElementList;
import com.ibm.cics.common.util.Debug;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class HistoryProviderDelegate
implements Constants,
IHistoryProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Date fromDate;
    private Date toDate;
    private Configuration configuration;
    private IHistoryCompatible historyCompatible;
    protected static Logger logger = Logger.getLogger("com.ibm.cics.cm.model");

    public HistoryProviderDelegate(IHistoryCompatible historyCompatible) {
        this.historyCompatible = historyCompatible;
        this.configuration = historyCompatible.getConfiguration();
        Calendar since = Calendar.getInstance();
        since.add(2, -3);
        this.fromDate = since.getTime();
    }

    @Override
    public Date getHistoryFromDate() {
        return this.fromDate;
    }

    @Override
    public String getHistoryFromDateAsDisplay() {
        if (this.fromDate == null) {
            return "EARLIEST";
        }
        return CMUtilities.toStringyyyyMMddDate(this.fromDate);
    }

    @Override
    public Date getHistoryToDate() {
        return this.toDate;
    }

    @Override
    public String getHistoryToDateAsDisplay() {
        if (this.toDate == null) {
            return "LATEST";
        }
        return CMUtilities.toStringyyyyMMddDate(this.toDate);
    }

    @Override
    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    @Override
    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    protected void appendTo(RestrictionCriteriaList resCriteriaList) {
    }

    @Override
    public IFilteredCollection<History> getHistory(List<IRestrictionCriteria> filters) {
        if (filters == null) {
            filters = Collections.EMPTY_LIST;
        }
        JournalCriteria journalCriteria = this.getJournalCriteria();
        LocationCriteria locationCriteria = LocationCriteria.newJournalLocationCriteria();
        FilteredCollection history = new FilteredCollection(new CMListFactory(locationCriteria, journalCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.journalCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getHistory", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    while (iterator.hasNext()) {
                        ICMObject object;
                        Map<String, String> attributes = iterator.next();
                        if (attributes.get("A_CRC").equals(attributes.get("B_CRC")) || (object = HistoryProviderDelegate.this.getObject(attributes)) == null) continue;
                        objects.add(object);
                    }
                    return objects;
                }
                return null;
            }
        });
        RestrictionElementList restrictionElementList = new RestrictionElementList();
        if (this.fromDate != null) {
            restrictionElementList.add(new RestrictionCriteria("JNLCREATETIME", FilterExpression.Operator.GE, CMUtilities.toStringyyyyMMddDate(this.fromDate)));
        }
        if (this.toDate != null) {
            restrictionElementList.add(new RestrictionCriteria("JNLCREATETIME", FilterExpression.Operator.LE, CMUtilities.toStringyyyyMMddDate(this.toDate)));
        } else {
            restrictionElementList.add(new RestrictionCriteria("JNLCREATETIME", FilterExpression.Operator.LE, "9999/12/31.23:59:59.99"));
        }
        restrictionElementList.add(new RestrictionCriteria("JNLOBJTYPE", FilterExpression.Operator.NE, "KEYASSOC"));
        restrictionElementList.add(new RestrictionCriteria("JNLRET_CODE", FilterExpression.Operator.LE, "0004"));
        if (this.configuration != null) {
            restrictionElementList.add(new RestrictionCriteria("JNLCCONFIG", FilterExpression.Operator.EQ, this.configuration.getName()));
        }
        List<RestrictionCriteria> additionalCriteria = this.getAdditionalCriteria();
        for (RestrictionCriteria restrictionCriteria : additionalCriteria) {
            restrictionElementList.add(restrictionCriteria);
        }
        for (IRestrictionCriteria filter : filters) {
            restrictionElementList.add((RestrictionCriteria)filter);
        }
        RestrictionCriteriaList restrictionCriteriaList = new RestrictionCriteriaList();
        restrictionCriteriaList.add(restrictionElementList);
        history.setRestrictionCriteriaList(restrictionCriteriaList);
        return history;
    }

    @Override
    public IFilteredCollection<History> getHistory(boolean includeRuntimeEvents, List<IRestrictionCriteria> filters) {
        if (!includeRuntimeEvents) {
            return this.getHistory(filters);
        }
        if (filters == null) {
            filters = Collections.EMPTY_LIST;
        }
        final IFilteredCollection<History> basicHistory = this.getHistory(filters);
        JournalCriteria journalCriteria = this.getJournalEventCriteria();
        LocationCriteria locationCriteria = LocationCriteria.newJournalLocationCriteria();
        FilteredCollection history = new FilteredCollection(new CMListFactory(locationCriteria, journalCriteria){

            @Override
            public List<ICMObject> getResults() {
                ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                List basicResults = basicHistory.getResults();
                objects.addAll(basicResults);
                if (ConfigurationManager.getCurrent().getConnection().getAPILevel().compareTo("CCV510") >= 0) {
                    ListMessageResponse response = null;
                    try {
                        response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.journalCriteria, this.restrictionCriteriaList);
                    }
                    catch (CMServerListException e) {
                        Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getHistory", (String)"CM Server List Exception", (Throwable)e);
                    }
                    if (response != null) {
                        Iterator<Map<String, String>> iterator = response.getObjects();
                        while (iterator.hasNext()) {
                            Map<String, String> attributes = iterator.next();
                            ICMObject object = HistoryProviderDelegate.this.getObject(attributes);
                            if (object == null) continue;
                            objects.add(object);
                        }
                    }
                }
                return objects;
            }
        });
        RestrictionElementList restrictionElementList = new RestrictionElementList();
        if (this.fromDate != null) {
            restrictionElementList.add(new RestrictionCriteria("JNLCREATETIME", FilterExpression.Operator.GE, CMUtilities.toStringyyyyMMddDate(this.fromDate)));
        }
        if (this.toDate != null) {
            restrictionElementList.add(new RestrictionCriteria("JNLCREATETIME", FilterExpression.Operator.LE, CMUtilities.toStringyyyyMMddDate(this.toDate)));
        } else {
            restrictionElementList.add(new RestrictionCriteria("JNLCREATETIME", FilterExpression.Operator.LE, "9999/12/31.23:59:59.99"));
        }
        if (this.configuration != null) {
            restrictionElementList.add(new RestrictionCriteria("JNLCCONFIG", FilterExpression.Operator.EQ, this.configuration.getName()));
        }
        restrictionElementList.add(new RestrictionCriteria("JNLOBJTYPE", FilterExpression.Operator.NE, "KEYASSOC"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "UPDATE"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "CREATE"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "DELETE"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "COPY"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "IMPORT"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "READY"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "UNREADY"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "APPROVE"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "DISAPPROVE"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "MIGRATE"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "BACKOUT"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "ADD"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "REMOVE"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "RENAME"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "ALTER"));
        restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.NE, "RECOVER"));
        List<RestrictionCriteria> additionalCriteria = this.getAdditionalCriteria();
        for (RestrictionCriteria restrictionCriteria : additionalCriteria) {
            restrictionElementList.add(restrictionCriteria);
        }
        for (IRestrictionCriteria filter : filters) {
            restrictionElementList.add((RestrictionCriteria)filter);
        }
        RestrictionCriteriaList restrictionCriteriaList = new RestrictionCriteriaList();
        restrictionCriteriaList.add(restrictionElementList);
        history.setRestrictionCriteriaList(restrictionCriteriaList);
        return history;
    }

    protected List<RestrictionCriteria> getAdditionalCriteria() {
        return Collections.EMPTY_LIST;
    }

    protected abstract JournalCriteria getJournalCriteria();

    protected abstract JournalCriteria getJournalEventCriteria();

    @Override
    public Date getChangeTime() {
        return this.historyCompatible.getChangeTime();
    }

    @Override
    public String getName() {
        return this.historyCompatible.getName();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected ICMObject getObject(Map<String, String> attributes) {
        return new History(this, attributes);
    }

    @Override
    public IHistoryProvider getIHistoryProvider() {
        return this;
    }
}

