/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.common.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class HistoryEntry
extends CMObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Date displayChangeTime;
    private Map<String, String> beforeAttributes;
    private Map<String, String> afterAttributes;
    private Map<String, Change> changes;
    private Date changeTime;

    public HistoryEntry(Map<String, String> journalObjectAttributes, Map<String, String> attributesBeforeChange, Map<String, String> attributesAfterChange) {
        super(journalObjectAttributes);
        String disTimeString;
        String chTimeString;
        String string = chTimeString = attributesAfterChange == null ? attributesBeforeChange.get("CHANGETIME") : attributesAfterChange.get("CHANGETIME");
        if (!StringUtil.hasContent((String)chTimeString)) {
            chTimeString = journalObjectAttributes.get("CREATETIME");
        }
        this.changeTime = CMUtilities.asDatayyyyMMddHHmmssSS(chTimeString);
        this.beforeAttributes = attributesBeforeChange;
        this.afterAttributes = attributesAfterChange;
        this.filterUnwantedAttributes(this.beforeAttributes);
        this.filterUnwantedAttributes(this.afterAttributes);
        String string2 = disTimeString = attributesAfterChange == null ? attributesBeforeChange.get("CHANGETIME") : attributesAfterChange.get("CHANGETIME");
        if (!StringUtil.hasContent((String)disTimeString)) {
            disTimeString = journalObjectAttributes.get("CREATETIME");
            this.displayChangeTime = CMUtilities.asDatayyyyMMddHHmmssSS(disTimeString);
        } else {
            this.displayChangeTime = CMUtilities.asDatayyyyMMdd(disTimeString);
        }
    }

    public HistoryEntry(Map<String, String> journalObjectAttributes) {
        super(journalObjectAttributes);
        String chTimeString = journalObjectAttributes.get("CREATETIME");
        this.changeTime = CMUtilities.asDatayyyyMMddHHmmssSS(chTimeString);
        this.displayChangeTime = CMUtilities.asDatayyyyMMddHHmmssSS(chTimeString);
        this.afterAttributes = journalObjectAttributes;
        this.filterUnwantedAttributes(this.afterAttributes);
    }

    private void filterUnwantedAttributes(Map<String, String> attributes) {
        String type;
        if (attributes != null && (type = attributes.get("TYPE")) != null && type.equals("ZFSFILE")) {
            attributes.remove("OBJECTINSTANCE");
        }
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public Map<String, Change> getChanges() {
        block7: {
            if (this.changes != null) break block7;
            this.changes = new HashMap<String, Change>();
            if (this.beforeAttributes == null) {
                for (Map.Entry<String, String> afterEntry : this.afterAttributes.entrySet()) {
                    this.changes.put(afterEntry.getKey(), new Change(null, afterEntry.getValue()));
                }
            } else if (this.afterAttributes == null) {
                for (Map.Entry<String, String> beforeEntry : this.beforeAttributes.entrySet()) {
                    this.changes.put(beforeEntry.getKey(), new Change(beforeEntry.getValue(), null));
                }
            } else {
                for (Map.Entry<String, String> afterEntry : this.afterAttributes.entrySet()) {
                    String beforeValue;
                    if (afterEntry.getKey().equals("CHANGETIME") || (beforeValue = this.beforeAttributes.get(afterEntry.getKey())) != null && beforeValue.equals(afterEntry.getValue())) continue;
                    this.changes.put(afterEntry.getKey(), new Change(beforeValue, afterEntry.getValue()));
                }
            }
        }
        return this.changes;
    }

    public Map<String, String> getBeforeAttributes() {
        return this.beforeAttributes;
    }

    public Map<String, String> getAfterAttributes() {
        return this.afterAttributes;
    }

    public Date getDisplayChangeTime() {
        return this.displayChangeTime;
    }

    public class Change {
        private String oldValue;
        private String newValue;

        Change(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public String getBeforeValue() {
            return this.oldValue;
        }

        public String getAfterValue() {
            return this.newValue;
        }

        public String toString() {
            return "<" + this.oldValue + ">-<" + this.newValue + ">";
        }
    }
}

