/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.ConfigurationConnection;
import com.ibm.cics.cm.model.ConfigurationContext;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.FilteredCollection;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.HistoryProviderDelegate;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.IHistoryCompatible;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.MutableConfiguration;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.model.definitions.ResourceDefinitionFactory;
import com.ibm.cics.cm.model.runtime.CMListFactory;
import com.ibm.cics.cm.model.runtime.CMServerDeleteException;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ProcessParms;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.model.InstallTarget;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IScopedContext;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Configuration
extends CMObject
implements IHistoryCompatible,
IContextProvider,
IRepository {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, ResourceDefinitionGroup> resourceGroupsByName;
    private Date changeTime;
    private HistoryProviderDelegate historyProviderDelegate;
    protected static Logger logger = Logger.getLogger("com.ibm.cics.cm.model");
    private List<ConfigurationListener> listeners = new ArrayList<ConfigurationListener>();
    private boolean deleted;

    public Configuration(Map<String, String> attributes) {
        super(attributes);
        this.setName(attributes.get("NAME"));
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -3);
        Date fromDate = calendar.getTime();
        this.getChangeTime();
        this.historyProviderDelegate = new HistoryProviderDelegate(this){

            @Override
            protected JournalCriteria getJournalCriteria() {
                return JournalCriteria.newJournalCriteriaForConfiguration(this.getName());
            }

            @Override
            protected JournalCriteria getJournalEventCriteria() {
                return JournalCriteria.newJournalEventCriteriaForConfiguration(this.getName());
            }
        };
        this.historyProviderDelegate.setFromDate(fromDate);
    }

    public MutableConfiguration asMutableConfiguration() {
        return new MutableConfiguration(this, ConfigurationManager.getCurrent());
    }

    public IFilteredCollection<ICMDefinition> getDefinitions() {
        return this.getDefinitions(true);
    }

    public IFilteredCollection<ICMDefinition> getDefinitions(final boolean skinny) {
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup("*", "*");
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getName());
        FilteredCollection definitions = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getDefinitions", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(ResourceDefinitionFactory.getObject(Configuration.this, attributes, skinny));
                    }
                    return objects;
                }
                return null;
            }
        });
        return definitions;
    }

    public ResourceDefinitionGroup getResourceGroup(String aResourceGroupName) {
        if (this.resourceGroupsByName == null || this.resourceGroupsByName.get(aResourceGroupName) == null) {
            this.refreshResourceGroups();
        }
        return this.resourceGroupsByName.get(aResourceGroupName);
    }

    private void refreshResourceGroups() {
        this.resourceGroupsByName = new HashMap<String, ResourceDefinitionGroup>();
        IFilteredCollection<ResourceDefinitionGroup> groups = this.getResourceGroups();
        for (ResourceDefinitionGroup resourceGroup : groups) {
            this.resourceGroupsByName.put(resourceGroup.getName(), resourceGroup);
        }
    }

    public ResourceList getResourceList(String aResourceListName) {
        IFilteredCollection<ResourceList> resourceLists = this.getResourceLists();
        resourceLists.setObjectName(aResourceListName);
        return resourceLists.size() > 0 ? resourceLists.get(0) : null;
    }

    public IFilteredCollection<ResourceList> getResourceLists() {
        ObjectCriteria objectCriteria = ObjectCriteria.newResourceListCriteria();
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getName());
        return new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getResourceLists", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(new ResourceList(Configuration.this, attributes));
                    }
                    return objects;
                }
                return CMObject.EMPTY_LIST;
            }
        });
    }

    public IFilteredCollection<ResourceDefinitionGroup> getResourceGroups() {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectType("RESGROUP");
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getName());
        FilteredCollection resourceGroups = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getResourceGroups", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(new ResourceDefinitionGroup(Configuration.this, attributes));
                    }
                    return objects;
                }
                return CMObject.EMPTY_LIST;
            }
        });
        return resourceGroups;
    }

    public ICMDefinition getDefinition(String type, String name) {
        IFilteredCollection<ICMDefinition> definitions = this.getDefinitions();
        definitions.setObjectName(name);
        definitions.setObjectType(type);
        if (definitions.size() >= 1) {
            return definitions.iterator().next();
        }
        return null;
    }

    public IFilteredCollection<ResourceDefinitionGroup> getOrphanedGroups() {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectType("RESINDSC");
        objectCriteria.setObjectGroup("*");
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getName());
        FilteredCollection resourceGroups = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                IFilteredCollection<ResourceDefinitionGroup> allResourceGroups = Configuration.this.getResourceGroups();
                LinkedHashMap<String, ResourceDefinitionGroup> groups = new LinkedHashMap<String, ResourceDefinitionGroup>();
                for (ResourceDefinitionGroup resourceDefinitionGroup : allResourceGroups) {
                    groups.put(resourceDefinitionGroup.getName(), resourceDefinitionGroup);
                }
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getOrphanedGroups", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        groups.remove(attributes.get("RESGROUP"));
                    }
                }
                return new ArrayList<ICMObject>(groups.values());
            }
        });
        return resourceGroups;
    }

    public boolean equals(Object o) {
        return o instanceof Configuration && ((Configuration)o).getName().equals(this.getName());
    }

    public ProcessParms getInstallProcessParms(IScopedContext target, boolean quiesce, boolean discard) {
        return null;
    }

    public ProcessParms getInstallProcessParms(ConfigurationConnection[] targets, boolean quiesce, boolean discard) {
        return null;
    }

    public IFilteredCollection<ICMDefinition> getDuplicatesByNameAndType() {
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup("*", "*");
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getName());
        FilteredCollection definitions = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getDuplicatesByNameAndTypeList(this.locationCriteria, this.objectCriteria);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getOrphanedDefinitions", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(ResourceDefinitionFactory.getObject(Configuration.this, attributes));
                    }
                    return objects;
                }
                return null;
            }
        });
        return definitions;
    }

    public IFilteredCollection<ICMDefinition> getUniqueNames() {
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup("*", "*");
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getName());
        FilteredCollection definitions = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getUniqueNames(this.locationCriteria, this.objectCriteria);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getOrphanedDefinitions", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(ResourceDefinitionFactory.getObject(Configuration.this, attributes));
                    }
                    return objects;
                }
                return null;
            }
        });
        return definitions;
    }

    public void setFromDate(Date fromDate) {
        this.historyProviderDelegate.setFromDate(fromDate);
    }

    @Override
    public Configuration getConfiguration() {
        return this;
    }

    @Override
    public Date getChangeTime() {
        String changeTimeAttrib = (String)this.attributes.get("CHANGETIME");
        if (changeTimeAttrib != null) {
            try {
                this.changeTime = CMUtilities.getyyyyMMddDateFormat().parse(changeTimeAttrib);
            }
            catch (ParseException e) {
                Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"Configuration", (Object[])new Object[]{this.attributes, e});
            }
            catch (Exception e) {
                Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"Configuration", (Object[])new Object[]{this.attributes, e});
            }
        }
        return this.changeTime;
    }

    public IFilteredCollection<History> getHistory(List<IRestrictionCriteria> filters) {
        return this.historyProviderDelegate.getHistory(true, filters);
    }

    @Override
    public IHistoryProvider getIHistoryProvider() {
        return this.historyProviderDelegate;
    }

    public static RestrictionCriteria getMRORestrictionCriteria() {
        return new RestrictionCriteria("RGroup", FilterExpression.Operator.EQ, "*");
    }

    public IContext getIContext() {
        return ConfigurationContext.newFrom(this);
    }

    public HashMap<String, String> getTransformationVariables() {
        HashMap<String, String> transVars = new HashMap<String, String>();
        try {
            int transVarCount = Integer.parseInt((String)this.attributes.get("LTVCOUNT"));
            int i = 0;
            while (i < transVarCount) {
                String value;
                String name = (String)this.attributes.get("XNAME" + i);
                if (name != null && (value = (String)this.attributes.get("XVALUE" + i)) != null) {
                    transVars.put(name, value);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return transVars;
    }

    public MessageResponse update() throws CMServerException {
        MessageResponse response = ConfigurationManager.getCurrent().update(this.asMutableConfiguration());
        this.notifyListeners(true);
        return response;
    }

    public boolean delete() throws CMServerDeleteException {
        boolean result = false;
        try {
            LocationCriteria locationCriteria = LocationCriteria.newRepositoryLocationCriteria();
            ObjectCriteria objectCriteria = ObjectCriteria.newConfigurationCriteria(this.getName());
            result = ConfigurationManager.getCurrent().delete(locationCriteria, objectCriteria);
        }
        catch (CMServerDeleteException de) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"delete", (String)"Delete failed.", (Throwable)de);
            throw de;
        }
        this.deleted = result;
        this.notifyListeners(true);
        return result;
    }

    public void setDescription(String newDescription) {
        this.attributes.put("DESCRIPTION", newDescription);
    }

    public boolean addListener(ConfigurationListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ConfigurationListener listener) {
        return this.listeners.remove(listener);
    }

    private void notifyListeners(boolean changed) {
        for (ConfigurationListener next : this.listeners) {
            next.notify(changed, this);
        }
    }

    public void setTransformationVariables(HashMap<String, String> transformationVariables) {
        this.clearTransformationVariables();
        int count = 0;
        for (Map.Entry<String, String> entry : transformationVariables.entrySet()) {
            this.attributes.put("XNAME" + count, entry.getKey());
            this.attributes.put("XVALUE" + count, entry.getValue());
            ++count;
        }
        this.attributes.put("LTVCOUNT", String.format("%08d", count));
    }

    private void clearTransformationVariables() {
        HashMap<String, String> newAttr = new HashMap<String, String>();
        for (Map.Entry entry : this.attributes.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("XNAME") || key.startsWith("XVALUE") || key.equals("LTVCOUNT")) continue;
            newAttr.put(key, (String)entry.getValue());
        }
        this.attributes = newAttr;
    }

    public void getFullConfiguration() {
        Configuration config = ConfigurationManager.getCurrent().getConfiguration(this.getName());
        this.attributes.putAll(config.getAttributes());
        this.notifyListeners(true);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted() {
        this.deleted = true;
        this.notifyListeners(true);
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public void setAttributes(Map<String, String> attributes) {
        Date oldChangeTime = this.getChangeTime();
        this.fillAttributes(attributes);
        Date newChangeTime = this.getChangeTime();
        if (oldChangeTime.compareTo(newChangeTime) < 0) {
            this.notifyListeners(true);
        }
    }

    public IRepository getRepository() {
        return this;
    }

    public List<InstallTarget> getInstallTargets() {
        return null;
    }

    public abstract class ConfigurationListener {
        private Configuration host;

        public ConfigurationListener(Configuration next) {
            this.host = next;
        }

        public abstract void notify(boolean var1, Configuration var2);

        public void dispose() {
            this.host.removeListener(this);
        }
    }
}

