/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.CMServerRemoveException;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.FilteredCollection;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMDefinition2;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.MutablePackage;
import com.ibm.cics.cm.model.PackageCommand;
import com.ibm.cics.cm.model.PackageScheme;
import com.ibm.cics.cm.model.PackageSchemeEvent;
import com.ibm.cics.cm.model.ReadyListCommand;
import com.ibm.cics.cm.model.ReadyListObject;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.model.builder.PackageSchemeBuilder;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupDefinition;
import com.ibm.cics.cm.model.runtime.CMListFactory;
import com.ibm.cics.cm.model.runtime.CMServerAddException;
import com.ibm.cics.cm.model.runtime.CMServerDeleteException;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.ContainerData;
import com.ibm.cics.cm.model.runtime.ListElement;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.model.runtime.Messages;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteriaList;
import com.ibm.cics.cm.model.runtime.ProcessParms;
import com.ibm.cics.cm.model.runtime.SelectionCriteria;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ChangePackage
extends CMObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DEFINITION_TYPE = "DEFINITION";
    public static final String COMMAND_TYPE = "COMMAND";
    public static final String TARGET_CONTAINER = "TCONTAINER";
    private String status;
    private ReadyListError readyListError;
    private List<ChangePackageListener> listeners = new ArrayList<ChangePackageListener>();
    public static final String CREATED = "CREATED";
    public static final String READY = "READY";
    public static final String MIGRATE = "MIGRATE";
    public static final String BACKOUT = "BACKOUT";

    public ChangePackage(Map<String, String> attributes) {
        super(attributes);
        this.setName(attributes.get("CPID"));
        this.updateStatus();
    }

    public void updateStatus() {
        this.status = (String)this.attributes.get("LC_APICMD");
    }

    public void updateAttributes(Map<String, String> anAttributesMap) {
        this.fillAttributes(anAttributesMap);
        this.updateStatus();
    }

    public String getStatus() {
        return this.status;
    }

    public IFilteredCollection<PackageScheme> getPackageSchemes(MigrationScheme scheme) {
        String schemeName = scheme != null ? scheme.getName() : "*";
        IFilteredCollection packageSchemes = ConfigurationManager.getCurrent().getFilteredCollection(PackageSchemeBuilder.getObjectFactory(), ObjectCriteria.newPackageSchemeCriteria(this.getName(), schemeName));
        return packageSchemes;
    }

    public MigrationScheme getLastScheme() {
        IFilteredCollection<MigrationScheme> migrationSchemes = ConfigurationManager.getCurrent().getMigrationSchemes();
        migrationSchemes.addRestrictionField("NAME", FilterExpression.Operator.EQ, (String)this.attributes.get("LC_SCHEME"));
        if (migrationSchemes.size() == 1) {
            return migrationSchemes.get(0);
        }
        return null;
    }

    public MutablePackage asMutablePackage() {
        return new MutablePackage(this, ConfigurationManager.getCurrent());
    }

    private IFilteredCollection<ICMObject> getReadyListCommon(String readyListType, final String scheme) {
        boolean flTemp = true;
        boolean icTemp = true;
        if (readyListType != null) {
            flTemp = false;
            if (readyListType.matches(DEFINITION_TYPE)) {
                icTemp = false;
            } else if (readyListType.matches(COMMAND_TYPE)) {
                icTemp = true;
            } else {
                flTemp = true;
            }
        }
        final boolean fullList = flTemp;
        final boolean isCommand = icTemp;
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForChangePackageList(this.getName());
        if (StringUtil.hasContent((String)scheme)) {
            objectCriteria.setScheme(scheme);
        }
        LocationCriteria locationCriteria = LocationCriteria.newRepositoryLocationCriteria();
        FilteredCollection definitions = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    if (e.areNoMigrateOrReadyObjects()) {
                        response = (ListMessageResponse)e.getMessageResponse();
                    }
                    Debug.warning((Logger)ChangePackage.this.logger, (String)this.getClass().getName(), (String)"getReadyListCommon", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ChangePackage.this.readyListError = new ReadyListError(response.returnCode, response.reasonCode);
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        ReadyListObject rlo = null;
                        if (!fullList) {
                            if (attributes.containsKey("CMDAPOST")) {
                                String cmdapost = attributes.get("CMDAPOST");
                                if (isCommand && (StringUtil.hasContent((String)scheme) || cmdapost.equals("CMDATARGET"))) {
                                    rlo = new ReadyListCommand(attributes);
                                    rlo.attributes.put("COMMAND_ASSOCIATION", cmdapost);
                                }
                            } else if (!isCommand) {
                                rlo = new ReadyListObject(attributes);
                            }
                        } else {
                            rlo = new ReadyListObject(attributes);
                        }
                        if (rlo == null) continue;
                        objects.add(rlo);
                    }
                    return objects;
                }
                ChangePackage.this.readyListError = null;
                return null;
            }
        });
        return definitions;
    }

    public IFilteredCollection<ICMObject> getResources(String scheme) {
        return this.getReadyListCommon(DEFINITION_TYPE, scheme);
    }

    public IFilteredCollection<ICMObject> getCommands(String scheme) {
        return this.getReadyListCommon(COMMAND_TYPE, scheme);
    }

    public IFilteredCollection<ICMObject> getReadyList(String scheme) {
        return this.getReadyListCommon(null, scheme);
    }

    public void addDefinitions(List<ICMDefinition2> cmDefs, Configuration sourceConfiguration) throws CMServerAddException {
        LocationCriteria locCrit = LocationCriteria.newRepositoryLocationCriteria();
        ObjectCriteriaList objCrit = ObjectCriteriaList.newObjectCriteriaList();
        objCrit.addObjectParameter("CCONFIG", sourceConfiguration.getName());
        for (ICMDefinition2 next : cmDefs) {
            if (next instanceof CICSRegionGroupDefinition) {
                objCrit.addListElement("", ((CICSRegionGroupDefinition)next).getType(), ((CICSRegionGroupDefinition)next).getResourceGroupName());
                continue;
            }
            if (next instanceof ICMDefinition) {
                objCrit.addListElement(((ICMDefinition)next).getResourceGroupName(), next.getType(), next.getName());
                continue;
            }
            objCrit.addListElement("", next.getType(), next.getName());
        }
        ContainerData conData = ContainerData.newContainerDataForChangePackage(this.getName());
        MessageResponse response = null;
        try {
            response = ConfigurationManager.getCurrent().add(locCrit, objCrit, conData, null);
        }
        catch (CMServerException se) {
            Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"addDefinitions", (String)("Error adding definitions to package " + this.getName()), (Throwable)se);
            throw new CMServerAddException(se.getMessageResponse());
        }
        this.notifyListeners(true);
    }

    public void addResourceLists(List<ResourceList> resourceLists, Configuration sourceConfiguration) throws CMServerAddException {
        LocationCriteria locCrit = LocationCriteria.newRepositoryLocationCriteria();
        ObjectCriteriaList objCrit = ObjectCriteriaList.newObjectCriteriaList();
        objCrit.addObjectParameter("CCONFIG", sourceConfiguration.getName());
        for (ResourceList next : resourceLists) {
            objCrit.addListElement(null, "RESDESC", next.getName());
        }
        ContainerData conData = ContainerData.newContainerDataForChangePackage(this.getName());
        try {
            ConfigurationManager.getCurrent().add(locCrit, objCrit, conData, null);
        }
        catch (CMServerException se) {
            Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"addResouceLists", (String)("Error adding resource lists to package " + this.getName()), (Throwable)se);
        }
        this.notifyListeners(true);
    }

    public void removeResources(List<Map<String, String>> resources, String configurationName) throws CMServerRemoveException {
        LocationCriteria locCrit = LocationCriteria.newRepositoryLocationCriteria();
        ObjectCriteriaList objCrit = ObjectCriteriaList.newObjectCriteriaList();
        objCrit.addObjectParameter("CCONFIG", configurationName);
        for (Map<String, String> next : resources) {
            if (!next.get("SEL_OBJTYPE").equals("RESDESC")) {
                objCrit.addListElement(next.get("SEL_GROUP"), next.get("SEL_OBJTYPE"), next.get("SEL_OBJNAME"));
                continue;
            }
            objCrit.addListElement(null, "RESDESC", next.get("SEL_OBJNAME"));
        }
        ContainerData conData = ContainerData.newContainerDataForChangePackage(this.getName());
        MessageResponse response = null;
        try {
            response = ConfigurationManager.getCurrent().remove(locCrit, objCrit, conData);
        }
        catch (CMServerException se) {
            Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"removeResources", (String)("Error removing resources from package " + this.getName()), (Throwable)se);
            response = se.getMessageResponse();
            throw new CMServerRemoveException(response);
        }
        this.notifyListeners(true);
    }

    public MessageResponse addCommands(List<PackageCommand> commands, Configuration configForTarget) throws CMServerAddException {
        LocationCriteria locCrit = LocationCriteria.newRepositoryLocationCriteria();
        ObjectCriteriaList objCrit = ObjectCriteriaList.newObjectCriteriaList();
        objCrit.addObjectParameter("CCONFIG", configForTarget.getName());
        for (PackageCommand next : commands) {
            objCrit.addListElement(next.getListElement());
        }
        ContainerData conData = ContainerData.newContainerDataForChangePackage(this.getName());
        ProcessParms replaceParms = ProcessParms.getReplace(true);
        MessageResponse response = null;
        try {
            response = ConfigurationManager.getCurrent().add(locCrit, objCrit, conData, replaceParms);
        }
        catch (CMServerException se) {
            Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"addDefinitions", (String)("Error adding definitions to package " + this.getName()), (Throwable)se);
            throw new CMServerAddException(se.getMessageResponse());
        }
        this.notifyListeners(true);
        return response;
    }

    public void removeCommands(List<Map<String, String>> commands, String configurationName) throws CMServerRemoveException {
        LocationCriteria locCrit = LocationCriteria.newRepositoryLocationCriteria();
        ObjectCriteriaList objCrit = ObjectCriteriaList.newObjectCriteriaList();
        objCrit.addObjectParameter("CCONFIG", configurationName);
        for (Map<String, String> next : commands) {
            ListElement le = null;
            le = !next.get("SEL_OBJTYPE").equals("RESGROUP") ? objCrit.addListElement(next.get("SEL_GROUP"), next.get("SEL_OBJTYPE"), next.get("SEL_OBJNAME")) : objCrit.addListElement(null, "RESGROUP", next.get("SEL_OBJNAME"));
            String commandCode = next.get("SEL_COMMAND");
            String commandText = "";
            commandText = commandCode.equals("A") ? PackageCommand.Type.ADD.toString() : (commandCode.equals("R") ? PackageCommand.Type.REMOVE.toString() : PackageCommand.Type.DELETE.toString());
            le.addAttribute(COMMAND_TYPE, commandText);
            le.addAttribute(TARGET_CONTAINER, next.get("SEL_TCONTAINER"));
        }
        ContainerData conData = ContainerData.newContainerDataForChangePackage(this.getName());
        MessageResponse response = null;
        try {
            response = ConfigurationManager.getCurrent().remove(locCrit, objCrit, conData);
        }
        catch (CMServerException se) {
            Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"removeCommands", (String)("Error removing commands from package " + this.getName()), (Throwable)se);
            response = se.getMessageResponse();
            throw new CMServerRemoveException(response);
        }
        this.notifyListeners(true);
    }

    public boolean deletePackage() throws CMServerDeleteException {
        boolean result = false;
        try {
            LocationCriteria locationCriteria = LocationCriteria.newRepositoryLocationCriteria();
            ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForChangePackageDelete(this.getName());
            result = ConfigurationManager.getCurrent().delete(locationCriteria, objectCriteria);
        }
        catch (CMServerDeleteException de) {
            Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"deletePackage", (String)"Delete failed.", (Throwable)de);
            throw de;
        }
        this.notifyListeners(true);
        return result;
    }

    public ReadyListError getLastReadyListError() {
        return this.readyListError;
    }

    public MessageResponse readyPackage(MigrationScheme scheme) {
        MessageResponse result = null;
        try {
            SelectionCriteria crit = SelectionCriteria.newSelectionCriteriaForChangePackage(this.getName(), scheme.getName());
            result = ConfigurationManager.getCurrent().ready(crit);
        }
        catch (CMServerException se) {
            Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"readyPackage", (String)"Ready failed.", (Throwable)se);
            result = se.getMessageResponse();
        }
        this.notifyListeners(true);
        return result;
    }

    public MessageResponse unreadyPackage(MigrationScheme scheme) {
        MessageResponse result = null;
        try {
            SelectionCriteria crit = SelectionCriteria.newSelectionCriteriaForChangePackage(this.getName(), scheme.getName());
            result = ConfigurationManager.getCurrent().unready(crit);
        }
        catch (CMServerException se) {
            Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"unreadyPackage", (String)"Unready failed.", (Throwable)se);
            result = se.getMessageResponse();
        }
        this.notifyListeners(true);
        return result;
    }

    public MessageResponse migratePackage(MigrationScheme scheme) {
        MessageResponse result = null;
        try {
            SelectionCriteria crit = SelectionCriteria.newSelectionCriteriaForChangePackage(this.getName(), scheme.getName());
            result = ConfigurationManager.getCurrent().migrate(crit);
        }
        catch (CMServerException se) {
            Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"migratePackage", (String)"Migrate failed.", (Throwable)se);
            result = se.getMessageResponse();
        }
        this.notifyListeners(true);
        return result;
    }

    public MessageResponse backoutEvent(MigrationScheme scheme, PackageSchemeEvent backoutEvent) {
        MessageResponse result = null;
        try {
            SelectionCriteria crit = SelectionCriteria.newSelectionCriteriaForChangePackage(this.getName(), scheme.getName());
            crit.setEventID(backoutEvent.getAttribute(PackageSchemeEvent.EventAttribute.CH_EVID));
            result = ConfigurationManager.getCurrent().backout(crit);
        }
        catch (CMServerException se) {
            Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"backoutEvent", (String)"Backout failed.", (Throwable)se);
            result = se.getMessageResponse();
        }
        this.notifyListeners(true);
        return result;
    }

    public boolean addListener(ChangePackageListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ChangePackageListener listener) {
        return this.listeners.remove(listener);
    }

    private void notifyListeners(boolean changed) {
        for (ChangePackageListener next : this.listeners) {
            next.notify(changed, this);
        }
    }

    public abstract class ChangePackageListener {
        private ChangePackage host;

        public ChangePackageListener(ChangePackage next) {
            this.host = next;
        }

        public abstract void notify(boolean var1, ChangePackage var2);

        public void dispose() {
            this.host.removeListener(this);
        }
    }

    public class ReadyListError {
        private int returnCode;
        private String reasonCode;

        public ReadyListError(int returnCode, String reasonCode) {
            this.returnCode = returnCode;
            this.reasonCode = reasonCode;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public String getReasonCode() {
            return this.reasonCode;
        }

        public boolean isInError() {
            return this.returnCode != 0;
        }

        public String getDescription() {
            if (this.isInError()) {
                String lastDigits = this.reasonCode.substring(4, 8);
                String description = com.ibm.cics.cm.model.Messages.getString("ReadyListError.reason." + lastDigits);
                if (CMUtilities.isNoMessageAvailable(description)) {
                    description = Messages.getString("ReasonCode_" + lastDigits + ".message");
                }
                return String.valueOf(description) + " (Reason : " + this.reasonCode + ")";
            }
            return com.ibm.cics.cm.model.Messages.getString("ReadyListError.00000000");
        }
    }
}

