/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CICSConfiguration;
import com.ibm.cics.cm.model.FilteredCollection;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.definitions.ResourceDefinitionFactory;
import com.ibm.cics.cm.model.runtime.CMListFactory;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ProcessParms;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.sm.comm.DREPRepository;
import com.ibm.cics.sm.comm.IScopedContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CPSMConfiguration
extends CICSConfiguration {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CPSMConfiguration(String aConfigurationName) {
        this(CPSMConfiguration.getMapForContext(aConfigurationName));
    }

    private static Map<String, String> getMapForContext(String aContextName) {
        HashMap<String, String> result = new HashMap<String, String>(1);
        result.put("CONTEXT", aContextName);
        return result;
    }

    public CPSMConfiguration(Map<String, String> attributes) {
        super(attributes);
    }

    public String getCPSMContext() {
        return this.getAttributes().get("CONTEXT");
    }

    public void setCPSMContext(String context) {
        this.getAttributes().put("CONTEXT", context);
    }

    public String getPlexName() {
        return this.getCPSMContext();
    }

    public IFilteredCollection<ICMDefinition> getOrphanedDefinitions() {
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup("*", "*");
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getName());
        FilteredCollection definitions = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getOrphanedResourcesList(this.locationCriteria, this.objectCriteria);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getOrphanedDefinitions", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(ResourceDefinitionFactory.getObject(CPSMConfiguration.this, attributes));
                    }
                    return objects;
                }
                return null;
            }
        });
        return definitions;
    }

    @Override
    public ProcessParms getInstallProcessParms(IScopedContext target, boolean quiesce, boolean discard) {
        return ProcessParms.getInstallForCPSM("YES", target.getScope());
    }

    public IFilteredCollection<ICMDefinition> getSharedResources() {
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup("*", "*");
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getName());
        FilteredCollection definitions = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getSharedResourcesList(this.locationCriteria, this.objectCriteria);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getOrphanedDefinitions", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(ResourceDefinitionFactory.getObject(CPSMConfiguration.this, attributes));
                    }
                    return objects;
                }
                return null;
            }
        });
        return definitions;
    }

    @Override
    public IRepository getRepository() {
        ArrayList targets = new ArrayList();
        return new DREPRepository(this.getName(), targets);
    }
}

