/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.comm.CMConnectionRecord;
import com.ibm.cics.cm.comm.CMConstants;
import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationOverrides;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMDefinition2;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.model.definitions.ResourceDefinitionFactory;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.model.runtime.RestrictionElementList;
import com.ibm.cics.core.model.AbstractCICSDefinitionType;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICSDResourceDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class CMUtilities
implements Constants,
CMConstants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static Map<String, ICICSAttribute[]> additionalCreateAttributesByTableName = new HashMap<String, ICICSAttribute[]>();
    private static Map<ICICSAttribute, String> defaultValues = new HashMap<ICICSAttribute, String>();
    private static ArrayList<String> cpsmAttributes;
    private static ArrayList<String> genericAttributes;
    private static String codePage;

    static {
        additionalCreateAttributesByTableName.put(CICSTypes.RequestModelDefinition.getResourceTableName(), new ICICSAttribute[]{CICSTypes.RequestModelDefinition.findAttributeByCicsName("RTYPE"), CICSTypes.RequestModelDefinition.findAttributeByCicsName("INTFACETYPE")});
        additionalCreateAttributesByTableName.put(CICSTypes.TransactionClassDefinition.getResourceTableName(), new ICICSAttribute[]{CICSTypes.TransactionClassDefinition.findAttributeByCicsName("MAXACTIVE")});
        additionalCreateAttributesByTableName.put(CICSTypes.TCPIPServiceDefinition.getResourceTableName(), new ICICSAttribute[]{CICSTypes.TCPIPServiceDefinition.findAttributeByCicsName("URM")});
        additionalCreateAttributesByTableName.put(CICSTypes.AtomServiceDefinition.getResourceTableName(), new ICICSAttribute[]{CICSTypes.AtomServiceDefinition.findAttributeByCicsName("RESOURCETYPE")});
        defaultValues.put(CICSTypes.AtomServiceDefinition.findAttributeByCicsName("RESOURCETYPE"), "N_A");
        defaultValues.put(CICSTypes.TCPIPServiceDefinition.findAttributeByCicsName("URM"), "");
        codePage = "cp037";
    }

    public static String getUnqualifiedClassName(Class aClass) {
        int indexOfLastPeriod = aClass.getName().lastIndexOf(46);
        return aClass.getName().substring(indexOfLastPeriod);
    }

    public static ICMObject[] toArray(IFilteredCollection configurations) {
        ICMObject[] result = new ICMObject[configurations.size()];
        Iterator iterator = configurations.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            result[i] = (ICMObject)iterator.next();
            ++i;
        }
        return result;
    }

    public static RestrictionCriteriaList includeAllAttributes(RestrictionCriteriaList restrictionCriteriaList, String objectType, Configuration configuration) {
        return CMUtilities.includeAllAttributes(restrictionCriteriaList, objectType, configuration, null, null);
    }

    public static RestrictionCriteriaList includeAllAttributes(RestrictionCriteriaList restrictionCriteriaList, String objectType, Configuration configuration, ObjectCriteria objectCriteria, IFilteredContext context) {
        if (objectType.equals("*")) {
            return restrictionCriteriaList;
        }
        ICICSAttribute[] attributeNames = CICSTypes.findForResourceTableName((String)objectType).attributes();
        ArrayList<String> attributeNamesList = new ArrayList<String>(attributeNames.length);
        ConfigurationOverrides configurationOverrides = ConfigurationOverrides.getOverrides(configuration, objectType);
        if (configurationOverrides != null) {
            int i = 0;
            while (i < attributeNames.length) {
                String attribute = attributeNames[i].getCicsName();
                String overriddenAttribute = configurationOverrides.getCMAttribute(attribute);
                if (overriddenAttribute != null) {
                    attributeNamesList.add(overriddenAttribute);
                }
                ++i;
            }
        }
        if (attributeNamesList != null) {
            if (restrictionCriteriaList == null) {
                restrictionCriteriaList = new RestrictionCriteriaList();
            }
            for (RestrictionElementList restrictionElementList : restrictionCriteriaList.getRestrictionElementLists()) {
                for (String attributeName : attributeNamesList) {
                    if (restrictionElementList.includesElementNamed(attributeName)) continue;
                    restrictionElementList.addUnique(new RestrictionCriteria(attributeName, FilterExpression.Operator.EQ, "*"));
                }
            }
        }
        if (context != null) {
            Set filteredAttributes = context.getAttributeNames();
            for (String attributeName : filteredAttributes) {
                if ("NAME".equals(attributeName)) {
                    if (objectCriteria == null) {
                        objectCriteria = new ObjectCriteria();
                    }
                    objectCriteria.setObjectName(context.getAttributeValue(attributeName));
                    continue;
                }
                if ("CSDGROUP".equals(attributeName)) {
                    if (objectCriteria == null) {
                        objectCriteria = new ObjectCriteria();
                    }
                    objectCriteria.setObjectGroup(context.getAttributeValue(attributeName));
                    continue;
                }
                if (configurationOverrides.getCMAttribute(attributeName) == null) continue;
                restrictionCriteriaList.add(new RestrictionCriteria(attributeName, FilterExpression.Operator.EQ, context.getAttributeValue(attributeName)));
            }
        }
        return restrictionCriteriaList;
    }

    private static Collection<String> getCPSMAttributes() {
        if (cpsmAttributes == null) {
            cpsmAttributes = new ArrayList();
            cpsmAttributes.add("DEFVER");
            cpsmAttributes.add("CHANGETIME");
        }
        return cpsmAttributes;
    }

    private static Collection<String> getGenericAttributes() {
        if (genericAttributes == null) {
            genericAttributes = new ArrayList();
            genericAttributes.add("CREATETIME");
            genericAttributes.add("NAME");
        }
        return genericAttributes;
    }

    public static ICICSAttribute[] filterBadAttributes(ICICSAttribute[] attributes, String definitionType) {
        ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(null, definitionType);
        ArrayList<ICICSAttribute> attributeList = new ArrayList<ICICSAttribute>();
        if (overrides != null) {
            int i = 0;
            while (i < attributes.length) {
                String attribute = attributes[i].getCicsName();
                String overriddenAttribute = overrides.getCMAttribute(attribute);
                if (overriddenAttribute != null) {
                    attributeList.add(attributes[i]);
                }
                ++i;
            }
        }
        return attributeList.toArray(new ICICSAttribute[attributeList.size()]);
    }

    public static Date asDatayyyyMMdd(String aDateString) {
        try {
            return CMUtilities.getyyyyMMddDateFormat().parse(aDateString);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date asDatayyyyMMddHHmmss(String aDateString) {
        try {
            return CMUtilities.getyyyyMMddHHmmssDateFormat().parse(aDateString);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date asDatayyyyMMddHHmmssSS(String aDateString) {
        try {
            return CMUtilities.getyyyyMMddHHmmssSSDateFormat().parse(aDateString);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static DateFormat getyyyyMMddDateFormat() {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    public static DateFormat getyyyyMMddHHmmssDateFormat() {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    public static DateFormat getyyyyMMddHHmmssSSDateFormat() {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SS");
    }

    public static String toStringyyyyMMddDate(Date changeTime) {
        return CMUtilities.getyyyyMMddDateFormat().format(changeTime);
    }

    public static String toStringyyyyMMddHHmmssSSDate(Date changeTime) {
        return CMUtilities.getyyyyMMddHHmmssSSDateFormat().format(changeTime);
    }

    public static String toStringyyyyMMddHHmmssDate(Date changeTime) {
        return CMUtilities.getyyyyMMddHHmmssDateFormat().format(changeTime);
    }

    public static IContext getContext(ICICSDefinition smDefinition) {
        try {
            Method getContextMethod = smDefinition.getClass().getMethod("getContext", new Class[0]);
            return (IContext)getContextMethod.invoke((Object)smDefinition, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IContext getContext(IResourceGroupDefinition aResourceGroupDefinition) {
        try {
            Method getContextMethod = aResourceGroupDefinition.getClass().getMethod("getIContext", new Class[0]);
            return (IContext)getContextMethod.invoke((Object)aResourceGroupDefinition, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IContext getIContext(Object anObject) {
        try {
            Method getContextMethod = anObject.getClass().getMethod("getIContext", new Class[0]);
            return (IContext)getContextMethod.invoke(anObject, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isEqual(ICMDefinition existingInput, ICMDefinition resourceDefinition) {
        return existingInput.getConfiguration().equals(resourceDefinition.getConfiguration()) && existingInput.getResourceGroup().equals(resourceDefinition.getResourceGroup()) && existingInput.getType().equals(resourceDefinition.getType()) && existingInput.getName().equals(resourceDefinition.getName());
    }

    public static String encodeToEBCDICValue(String value) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, "+");
            String[] tokens = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                tokens[i] = URLEncoder.encode(tokenizer.nextToken(), codePage);
                tokens[i] = tokens[i].replace('+', ' ');
                tokens[i] = tokens[i].replace("%A1", "~");
                tokens[i] = tokens[i].replace("%5A", "!");
                tokens[i] = tokens[i].replace("%7C", "@");
                tokens[i] = tokens[i].replace("%7B", "#");
                tokens[i] = tokens[i].replace("%5B", "$");
                tokens[i] = tokens[i].replace("%5C", "*");
                tokens[i] = tokens[i].replace("%4D", "(");
                tokens[i] = tokens[i].replace("%5D", ")");
                tokens[i] = tokens[i].replace("%4E", "+");
                tokens[i] = tokens[i].replace("%7E", "=");
                tokens[i] = tokens[i].replace("%C0", "{");
                tokens[i] = tokens[i].replace("%D0", "}");
                tokens[i] = tokens[i].replace("%BA", "[");
                tokens[i] = tokens[i].replace("%BB", "]");
                tokens[i] = tokens[i].replace("%E0", "\\");
                tokens[i] = tokens[i].replace("%7A", ":");
                tokens[i] = tokens[i].replace("%5E", ";");
                tokens[i] = tokens[i].replace("%6B", ",");
                tokens[i] = tokens[i].replace("%61", "/");
                tokens[i] = tokens[i].replace("%6F", "?");
                ++i;
            }
            StringBuffer buffer = new StringBuffer();
            int tokenPointer = 0;
            StringBuffer originalStringBuffer = new StringBuffer();
            originalStringBuffer.append(value);
            boolean go = true;
            while (originalStringBuffer.length() > 0) {
                int indexOf = originalStringBuffer.indexOf("+");
                if (indexOf == 0) {
                    buffer.append('+');
                    originalStringBuffer.deleteCharAt(0);
                    continue;
                }
                if (indexOf < 0) {
                    buffer.append(tokens[tokenPointer]);
                    originalStringBuffer.delete(0, originalStringBuffer.capacity());
                    continue;
                }
                buffer.append(tokens[tokenPointer]);
                buffer.append('+');
                originalStringBuffer.delete(0, indexOf + 1);
                ++tokenPointer;
            }
            return buffer.toString();
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static String decodeFromEBCDICValue(String value) throws UnsupportedEncodingException {
        StringTokenizer tokenizer = new StringTokenizer(value, "+");
        String[] tokens = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i] = URLDecoder.decode(tokenizer.nextToken(), codePage);
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        int tokenPointer = 0;
        StringBuffer originalStringBuffer = new StringBuffer();
        originalStringBuffer.append(value);
        while (originalStringBuffer.length() > 0) {
            int indexOf = originalStringBuffer.indexOf("+");
            if (indexOf == 0) {
                buffer.append('+');
                originalStringBuffer.deleteCharAt(0);
                continue;
            }
            if (indexOf < 0) {
                buffer.append(tokens[tokenPointer]);
                originalStringBuffer.delete(0, originalStringBuffer.capacity());
                continue;
            }
            buffer.append(tokens[tokenPointer]);
            buffer.append('+');
            originalStringBuffer.delete(0, indexOf + 1);
            ++tokenPointer;
        }
        return buffer.toString();
    }

    public static boolean isValidResourceTypeForRelease(ICICSType cicsType) {
        if (cicsType != null && (cicsType instanceof AbstractCICSDefinitionType || ResourceDefinitionFactory.isCMResourceType(cicsType.getResourceTableName()) || ResourceDefinitionFactory.isCMCPSMResourceAssociationType(cicsType.getResourceTableName()))) {
            return ConfigurationOverrides.isValidResourceTypeForRelease(cicsType);
        }
        return false;
    }

    public static SMConnectionRecord getRecordForCreate(String resourceType, SMConnectionRecord record, IContext context) {
        return CMUtilities.getRecordForCreate(resourceType, record, context, null);
    }

    public static SMConnectionRecord getRecordForCreate(String resourceType, SMConnectionRecord record, IContext context, Map<String, String> additionalAttributes) {
        HashMap<String, String> map = new HashMap<String, String>();
        ICICSAttribute[] attributes = additionalCreateAttributesByTableName.get(resourceType);
        if (attributes != null) {
            ICICSAttribute[] iCICSAttributeArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                ICICSAttribute attribute = iCICSAttributeArray[n2];
                String defaultValue = defaultValues.get(attribute);
                if (defaultValue != null) {
                    map.put(attribute.getCicsName(), defaultValue);
                } else {
                    map.put(attribute.getCicsName(), attribute.getDefaultValue().toString());
                }
                ++n2;
            }
        }
        if (record != null) {
            for (String attributeKey : record) {
                String attributeValue = record.get(attributeKey);
                if ("CSDGROUP".equals(attributeKey)) continue;
                map.put(attributeKey, attributeValue);
            }
        }
        if (additionalAttributes != null) {
            map.putAll(additionalAttributes);
        }
        return new CMConnectionRecord(map, null, context);
    }

    public static RestrictionCriteriaList asRestrictionCriteriaListForResourceGroup(IFilteredContext filteredContext, String type) {
        String attributeNameOfGroup = type.equals("CSDGROUP") || type.equals("CSDLIST") ? "NAME" : type;
        RestrictionCriteriaList result = new RestrictionCriteriaList();
        for (Object attributeName : filteredContext.getAttributeNames()) {
            String fieldName = (String)attributeName;
            if (attributeName.equals(attributeNameOfGroup)) continue;
            String attributeValue = filteredContext.getAttributeValue(fieldName);
            RestrictionCriteria restrictionCriteria = new RestrictionCriteria(fieldName, FilterExpression.Operator.EQ, attributeValue);
            result.add(restrictionCriteria);
        }
        return result.getFirstElementList().isEmpty() ? null : result;
    }

    public static boolean hasContent(Set aSet) {
        return aSet != null && aSet.size() > 0;
    }

    public static Map<String, Map<String, ICMDefinition>> asTypeNameMap(List<ICMDefinition> rightDefinitions) {
        HashMap<String, Map<String, ICMDefinition>> map = new HashMap<String, Map<String, ICMDefinition>>();
        for (ICMDefinition resourceDefinition : rightDefinitions) {
            Map<String, ICMDefinition> map2 = map.get(resourceDefinition.getType());
            if (map2 == null) {
                map2 = new HashMap<String, ICMDefinition>();
                map.put(resourceDefinition.getType(), map2);
            }
            map2.put(resourceDefinition.getName(), resourceDefinition);
        }
        return map;
    }

    public static Map<String, String> parseAdditionalErrorInfo(CMServerException e) {
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        List<String> additionalMessages = e.getAdditionalMessages();
        for (String string : additionalMessages) {
            String[] split;
            String[] stringArray = split = string.split("\\s+");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                String[] split2 = string2.split("=");
                if (split2.length == 2) {
                    additionalInfo.put(split2[0], split2[1]);
                }
                ++n2;
            }
        }
        return additionalInfo;
    }

    public static boolean isNoMessageAvailable(String string) {
        return string.startsWith("!") && string.endsWith("!");
    }

    public static Configuration getSingleConfiguration(Collection<ICICSDefinition> definitions) {
        Comparator<Configuration> configComparator = new Comparator<Configuration>(){

            @Override
            public int compare(Configuration o1, Configuration o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        TreeSet<Configuration> foundConfigs = new TreeSet<Configuration>(configComparator);
        for (ICICSDefinition next : definitions) {
            Configuration configuration;
            IContext cntxt = CMUtilities.getContext(next);
            if (cntxt == null || (configuration = CMSMConnection.getConfiguration(cntxt)) == null) continue;
            foundConfigs.add(configuration);
        }
        if (foundConfigs.size() == 1) {
            return foundConfigs.toArray(new Configuration[0])[0];
        }
        return null;
    }

    public static Map<Configuration, List<Object>> mapCMObjectByConfigurations(List<? extends ICMObject> inputObjects) {
        HashMap<Configuration, List<Object>> map = new HashMap<Configuration, List<Object>>();
        for (ICMObject iCMObject : inputObjects) {
            Configuration config;
            if (iCMObject instanceof ICMDefinition2) {
                config = ((ICMDefinition2)iCMObject).getConfiguration();
                CMUtilities.tryMapPut((ICMDefinition2)iCMObject, config, map);
                continue;
            }
            if (iCMObject instanceof ResourceList) {
                config = ((ResourceList)iCMObject).getConfiguration();
                CMUtilities.tryMapPut((ResourceList)iCMObject, config, map);
                continue;
            }
            if (!(iCMObject instanceof ResourceDefinitionGroup)) continue;
            config = ((ResourceDefinitionGroup)iCMObject).getConfiguration();
            CMUtilities.tryMapPut((ResourceDefinitionGroup)iCMObject, config, map);
        }
        return map;
    }

    private static void tryMapPut(ICMObject thing, Configuration config, Map<Configuration, List<Object>> map) {
        if (config != null) {
            List<Object> things = map.get(config);
            if (things == null) {
                things = new ArrayList<Object>();
                map.put(config, things);
            }
            things.add(thing);
        }
    }

    public static ICSDResourceDefinition.DeftypeValue resolveDeftypeValueFromCMType(String cmType) {
        HashMap<String, ICSDResourceDefinition.DeftypeValue> typeMap = new HashMap<String, ICSDResourceDefinition.DeftypeValue>();
        typeMap.put("ATOMDEF", ICSDResourceDefinition.DeftypeValue.ATOMSERVICE);
        typeMap.put("BUNDDEF", ICSDResourceDefinition.DeftypeValue.BUNDLE);
        typeMap.put("CONNDEF", ICSDResourceDefinition.DeftypeValue.CONNECTION);
        typeMap.put("EJCODEF", ICSDResourceDefinition.DeftypeValue.CORBASERVER);
        typeMap.put("DB2CDEF", ICSDResourceDefinition.DeftypeValue.DB2CONN);
        typeMap.put("DB2EDEF", ICSDResourceDefinition.DeftypeValue.DB2ENTRY);
        typeMap.put("DB2TDEF", ICSDResourceDefinition.DeftypeValue.DB2TRAN);
        typeMap.put("EJDJDEF", ICSDResourceDefinition.DeftypeValue.DJAR);
        typeMap.put("DOCDEF", ICSDResourceDefinition.DeftypeValue.DOCTEMPLATE);
        typeMap.put("ENQMDEF", ICSDResourceDefinition.DeftypeValue.ENQMODEL);
        typeMap.put("FILEDEF", ICSDResourceDefinition.DeftypeValue.FILE);
        typeMap.put("IPCONDEF", ICSDResourceDefinition.DeftypeValue.IPCONN);
        typeMap.put("JRNMDEF", ICSDResourceDefinition.DeftypeValue.JOURNALMODEL);
        typeMap.put("JVMSVDEF", ICSDResourceDefinition.DeftypeValue.JVMSERVER);
        typeMap.put("LIBDEF", ICSDResourceDefinition.DeftypeValue.LIBRARY);
        typeMap.put("LSRDEF", ICSDResourceDefinition.DeftypeValue.LSRPOOL);
        typeMap.put("MAPDEF", ICSDResourceDefinition.DeftypeValue.MAP);
        typeMap.put("MQCONDEF", ICSDResourceDefinition.DeftypeValue.MQCONN);
        typeMap.put("PRTNDEF", ICSDResourceDefinition.DeftypeValue.PARTITIONSET);
        typeMap.put("PARTDEF", ICSDResourceDefinition.DeftypeValue.PARTNER);
        typeMap.put("PIPEDEF", ICSDResourceDefinition.DeftypeValue.PIPELINE);
        typeMap.put("PROCDEF", ICSDResourceDefinition.DeftypeValue.PROCESSTYPE);
        typeMap.put("PROFDEF", ICSDResourceDefinition.DeftypeValue.PROFILE);
        typeMap.put("PROGDEF", ICSDResourceDefinition.DeftypeValue.PROGRAM);
        typeMap.put("RQMDEF", ICSDResourceDefinition.DeftypeValue.REQUESTMODEL);
        typeMap.put("SESSDEF", ICSDResourceDefinition.DeftypeValue.SESSIONS);
        typeMap.put("TCPDEF", ICSDResourceDefinition.DeftypeValue.TCPIPSERVICE);
        typeMap.put("TDQDEF", ICSDResourceDefinition.DeftypeValue.TDQUEUE);
        typeMap.put("TERMDEF", ICSDResourceDefinition.DeftypeValue.TERMINAL);
        typeMap.put("TRNCLDEF", ICSDResourceDefinition.DeftypeValue.TRANCLASS);
        typeMap.put("TRANDEF", ICSDResourceDefinition.DeftypeValue.TRANSACTION);
        typeMap.put("TSMDEF", ICSDResourceDefinition.DeftypeValue.TSMODEL);
        typeMap.put("TYPTMDEF", ICSDResourceDefinition.DeftypeValue.TYPETERM);
        typeMap.put("URIMPDEF", ICSDResourceDefinition.DeftypeValue.URIMAP);
        typeMap.put("WEBSVDEF", ICSDResourceDefinition.DeftypeValue.WEBSERVICE);
        return (ICSDResourceDefinition.DeftypeValue)typeMap.get(cmType);
    }
}

