/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.FilterAttribute;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.IllegalAttributeException;
import com.ibm.cics.cm.model.Messages;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeHint;
import com.ibm.cics.model.ICICSEnum;
import com.ibm.cics.model.IllegalCICSAttributeException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CICSFilterAttribute
extends FilterAttribute {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ICICSAttribute<?> attribute;
    private ICICSAttributeHint valuesHint;
    private int max;
    private int min;
    private Map<ICICSEnum, String> valuesToDisplayNames;
    private FilterExpression filterExpression;
    private Class<?> attributeType;
    private String description;
    private String displayName;

    public CICSFilterAttribute(ICICSAttribute<?> attribute, String description, String displayName) {
        this.attributeType = attribute.getType();
        this.attribute = attribute;
        this.description = description;
        this.displayName = displayName;
        if (ICICSEnum.class.isAssignableFrom(this.attributeType)) {
            this.valuesToDisplayNames = CICSFilterAttribute.getDisplayValues(attribute);
        }
        this.valuesHint = attribute.getValuesHint();
        if (this.valuesHint.hasNumericRange()) {
            long[] numericRange = this.valuesHint.getNumericRange();
            this.min = (int)numericRange[0];
            this.max = (int)numericRange[1];
        }
        if (this.attributeType.isEnum()) {
            this.attributeType = Enum.class;
        }
    }

    private static <T extends ICICSEnum> Map<ICICSEnum, String> getDisplayValues(ICICSAttribute<T> attribute) {
        ICICSEnum[] enumConstants = (ICICSEnum[])attribute.getType().getEnumConstants();
        HashMap<ICICSEnum, String> map = new HashMap<ICICSEnum, String>();
        ICICSEnum[] iCICSEnumArray = enumConstants;
        int n = enumConstants.length;
        int n2 = 0;
        while (n2 < n) {
            ICICSEnum t = iCICSEnumArray[n2];
            if (!t.isSpecialValue()) {
                map.put(t, attribute.internalToExternal((Object)t));
            }
            ++n2;
        }
        return map;
    }

    @Override
    public String getAPIName() {
        return this.attribute.getCicsName();
    }

    @Override
    public String getDescriptiveName() {
        return this.description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getErrorMessage(String textValue) {
        ICICSAttributeHint valuesHint = this.attribute.getValuesHint();
        String message = null;
        if (valuesHint.hasMaxLength() && valuesHint.getMaxLength() < textValue.length()) {
            message = MessageFormat.format(Messages.getString("CICSFilterAttribute.error.toolong"), this.getDisplayName(), valuesHint.getMaxLength());
        } else if (valuesHint.hasNumericRange() && !valuesHint.hasSpecialValues()) {
            long[] numericRange = valuesHint.getNumericRange();
            message = MessageFormat.format(Messages.getString("CICSFilterAttribute.error.range"), this.getDisplayName(), numericRange[0], numericRange[1]);
        } else if (valuesHint.hasNumericRange() && valuesHint.hasSpecialValues()) {
            long[] numericRange = valuesHint.getNumericRange();
            Map specialValues = valuesHint.getSpecialValues();
            int noOfSpecialValues = specialValues.size();
            if (noOfSpecialValues == 1) {
                message = MessageFormat.format(Messages.getString("CICSFilterAttribute.error.rangeOrSingeSpecial"), this.getDisplayName(), numericRange[0], numericRange[1], specialValues.keySet().iterator().next());
            } else {
                int count = 0;
                StringBuffer buffer = new StringBuffer();
                for (Object string : specialValues.keySet()) {
                    buffer.append(string);
                    if (++count >= noOfSpecialValues) continue;
                    buffer.append(", ");
                }
                message = MessageFormat.format(Messages.getString("CICSFilterAttribute.error.rangeOrSingeSpecial"), this.getDisplayName(), numericRange[0], numericRange[1], buffer.toString());
            }
        }
        return message;
    }

    @Override
    public Class getType() {
        return this.attributeType;
    }

    @Override
    public int getMaximum() {
        return this.max;
    }

    @Override
    public int getMinimum() {
        return this.min;
    }

    @Override
    public Object[] getValues() {
        Set<ICICSEnum> keySet = this.valuesToDisplayNames.keySet();
        return keySet.toArray(new ICICSEnum[keySet.size()]);
    }

    @Override
    public void validate(String textValue) throws IllegalAttributeException {
        try {
            this.attribute.validate((Object)textValue);
        }
        catch (IllegalCICSAttributeException e) {
            throw new IllegalAttributeException((Exception)((Object)e));
        }
    }

    @Override
    public String getDisplayName(Object value) {
        return this.valuesToDisplayNames.get(value);
    }

    public String toString() {
        return this.displayName;
    }
}

