/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.compare.ui;

import com.ibm.cics.cm.compare.ui.CompareEditorContentProvider;
import com.ibm.cics.cm.compare.ui.CompareResourceExplorerEditorInput;
import com.ibm.cics.cm.compare.ui.DualDescriptor;
import com.ibm.cics.cm.compare.ui.Messages;
import com.ibm.cics.core.ui.editors.EditorPropertySheet;
import com.ibm.cics.core.ui.editors.IExplorerEditorInput;
import com.ibm.cics.model.ICICSAttribute;
import java.text.MessageFormat;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class CompareEditorPropertySheet
extends EditorPropertySheet {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    TreeViewerColumn leftValueColumnViewer;
    private CompareEditorContentProvider contentProvider;

    public CompareEditorPropertySheet(Composite container, IEditorActionBarContributor actionBarContributor) {
        super(container, null, null, false, actionBarContributor);
    }

    CompareResourceExplorerEditorInput getInput() {
        return (CompareResourceExplorerEditorInput)this.editorInput;
    }

    public void setInput(IExplorerEditorInput input) {
        super.setInput(input);
        IExplorerEditorInput leftInput = ((CompareResourceExplorerEditorInput)this.editorInput).getLeftInput();
        IExplorerEditorInput rightInput = ((CompareResourceExplorerEditorInput)this.editorInput).getRightInput();
        String plainValue = com.ibm.cics.core.ui.editors.Messages.getString((String)"EditorPropertySheet.value");
        String valueText = Messages.getString("CompareEditorPropertySheet.value");
        String leftText = leftInput != null ? MessageFormat.format(valueText, leftInput.getName()) : plainValue;
        this.leftValueColumnViewer.getColumn().setText(leftText);
        String rightText = rightInput != null ? MessageFormat.format(valueText, rightInput.getName()) : plainValue;
        this.valueColumnViewer.getColumn().setText(rightText);
    }

    protected void initializeAnyColumnsBetweenNameAndValue(TreeColumnLayout layout) {
        TreeColumn leftValueColumn = new TreeColumn(this.treeViewer.getTree(), 0);
        this.leftValueColumnViewer = new TreeViewerColumn(this.treeViewer, leftValueColumn);
        this.leftValueColumnViewer.setLabelProvider(this.getLeftValueColumnLabelProvider());
        layout.setColumnData((Widget)leftValueColumn, (ColumnLayoutData)new ColumnPixelData(200));
        leftValueColumn.setText(com.ibm.cics.core.ui.editors.Messages.getString((String)"EditorPropertySheet.value"));
    }

    protected CellLabelProvider getCicsNameColumnLabelProvider() {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IPropertyDescriptor descriptor;
                Object element = cell.getElement();
                if (element instanceof DualDescriptor && (descriptor = ((DualDescriptor)element).getDescriptor()) != null) {
                    cell.setText(CompareEditorPropertySheet.this.getCICSName(descriptor));
                }
            }
        };
    }

    protected CellLabelProvider getNameColumnLabelProvider() {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                String text = "UNKNOWN";
                if (element instanceof DualDescriptor) {
                    text = ((DualDescriptor)element).getDisplayName();
                } else if (element instanceof CompareEditorContentProvider.CompareTreeCategory) {
                    text = ((CompareEditorContentProvider.CompareTreeCategory)element).getCategory();
                }
                cell.setText(text);
            }
        };
    }

    protected CellLabelProvider getLeftValueColumnLabelProvider() {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IPropertyDescriptor descriptor;
                Object element = cell.getElement();
                if (element instanceof DualDescriptor && (descriptor = ((DualDescriptor)element).getLeftDescriptor()) != null) {
                    IExplorerEditorInput leftInput = ((CompareResourceExplorerEditorInput)CompareEditorPropertySheet.this.editorInput).getLeftInput();
                    cell.setText(descriptor.getLabelProvider().getText(leftInput.getPropertyValue(descriptor.getId())));
                    if (!CompareEditorPropertySheet.this.editorInput.isMutable(descriptor.getId())) {
                        cell.setForeground(CompareEditorPropertySheet.this.READ_ONLY);
                    }
                }
            }
        };
    }

    protected CellLabelProvider getValueColumnLabelProvider() {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IPropertyDescriptor descriptor;
                Object element = cell.getElement();
                if (element instanceof DualDescriptor && (descriptor = ((DualDescriptor)element).getRightDescriptor()) != null) {
                    cell.setText(descriptor.getLabelProvider().getText(CompareEditorPropertySheet.this.editorInput.getPropertyValue(descriptor.getId())));
                    if (!CompareEditorPropertySheet.this.editorInput.isMutable(descriptor.getId())) {
                        cell.setForeground(CompareEditorPropertySheet.this.READ_ONLY);
                    }
                }
            }
        };
    }

    public void selectAttribute(ICICSAttribute<?> att) {
        DualDescriptor dualDescriptorForAttribute = this.contentProvider.getDualDescriptorForAttribute(att);
        this.treeViewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{dualDescriptorForAttribute})));
    }

    protected IContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new CompareEditorContentProvider();
        }
        return this.contentProvider;
    }
}

