/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.compare.ui;

import com.ibm.cics.cm.compare.ui.CICSCompareEditorInput;
import com.ibm.cics.cm.compare.ui.CompareCICSObjectEditorInput;
import com.ibm.cics.cm.compare.ui.CompareResourceDefinitionGroupEditorInput;
import com.ibm.cics.cm.compare.ui.CompareResourceListEditorInput;
import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.model.CMContext;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.ui.views.HistoryView;
import com.ibm.cics.cm.ui.views.SearchResultsView;
import com.ibm.cics.core.model.CSDGroupDefinitionType;
import com.ibm.cics.core.model.CSDListDefinitionType;
import com.ibm.cics.core.model.ResourceDescriptionDefinitionType;
import com.ibm.cics.core.model.ResourceGroupDefinitionType;
import com.ibm.cics.core.ui.views.ResourcesView;
import com.ibm.cics.explorer.tables.ui.TableView;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.ICSDListDefinition;
import com.ibm.cics.model.IResourceDescriptionDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.sm.comm.IContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareCommandHandler
implements IHandler {
    static final String COPYRIGHT = "Copyright IBM Corp. 2008, 2025.";
    private static Logger logger = Logger.getLogger(CompareCommandHandler.class.getPackage().getName());

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        Object[] selectedElements = selection.toArray();
        ICICSType type = null;
        IContext inputContext = null;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        TableView tableView = TableView.getTableViewForIWorkbenchPart((IWorkbenchPart)part);
        if (tableView != null) {
            type = tableView.getTable().getType();
            inputContext = tableView.getContext();
        } else if (part instanceof ResourcesView) {
            ResourcesView resourcesView = (ResourcesView)part;
            type = resourcesView.getCICSType();
            inputContext = resourcesView.getContext();
        }
        if (type != null && (type.equals(ResourceDescriptionDefinitionType.getInstance()) || type.equals(ResourceGroupDefinitionType.getInstance()) || type.equals(CSDListDefinitionType.getInstance()) || type.equals(CSDGroupDefinitionType.getInstance()))) {
            CMContext cmContext = null;
            if (inputContext instanceof CMContext) {
                cmContext = (CMContext)inputContext;
            }
            Configuration conf = null;
            conf = cmContext != null ? cmContext.getConfiguration() : CMSMConnection.getConfiguration((IContext)inputContext);
            if (conf != null) {
                ResourceDefinitionGroup temporaryResourceGroup;
                ResourceList temporaryResourceList;
                if (type.equals(ResourceDescriptionDefinitionType.getInstance())) {
                    if (selectedElements[0] instanceof IResourceDescriptionDefinition && (temporaryResourceList = conf.getResourceList(((IResourceDescriptionDefinition)selectedElements[0]).getName())) != null) {
                        selectedElements[0] = temporaryResourceList;
                    }
                    if (selectedElements[1] instanceof IResourceDescriptionDefinition && (temporaryResourceList = conf.getResourceList(((IResourceDescriptionDefinition)selectedElements[1]).getName())) != null) {
                        selectedElements[1] = temporaryResourceList;
                    }
                } else if (type.equals(ResourceGroupDefinitionType.getInstance())) {
                    if (selectedElements[0] instanceof IResourceGroupDefinition && (temporaryResourceGroup = conf.getResourceGroup(((IResourceGroupDefinition)selectedElements[0]).getName())) != null) {
                        selectedElements[0] = temporaryResourceGroup;
                    }
                    if (selectedElements[1] instanceof IResourceGroupDefinition && (temporaryResourceGroup = conf.getResourceGroup(((IResourceGroupDefinition)selectedElements[1]).getName())) != null) {
                        selectedElements[1] = temporaryResourceGroup;
                    }
                } else if (type.equals(CSDListDefinitionType.getInstance())) {
                    if (selectedElements[0] instanceof ICSDListDefinition && (temporaryResourceList = conf.getResourceList(((ICSDListDefinition)selectedElements[0]).getName())) != null) {
                        selectedElements[0] = temporaryResourceList;
                    }
                    if (selectedElements[1] instanceof ICSDListDefinition && (temporaryResourceList = conf.getResourceList(((ICSDListDefinition)selectedElements[1]).getName())) != null) {
                        selectedElements[1] = temporaryResourceList;
                    }
                } else if (type.equals(CSDGroupDefinitionType.getInstance())) {
                    if (selectedElements[0] instanceof ICSDGroupDefinition && (temporaryResourceGroup = conf.getResourceGroup(((ICSDGroupDefinition)selectedElements[0]).getName())) != null) {
                        selectedElements[0] = temporaryResourceGroup;
                    }
                    if (selectedElements[1] instanceof ICSDGroupDefinition && (temporaryResourceGroup = conf.getResourceGroup(((ICSDGroupDefinition)selectedElements[1]).getName())) != null) {
                        selectedElements[1] = temporaryResourceGroup;
                    }
                }
            }
        }
        CICSCompareEditorInput input = null;
        ICICSObject leftObj = selectedElements[0] instanceof ICICSObject ? (ICICSObject)selectedElements[0] : (ICICSObject)Platform.getAdapterManager().loadAdapter(selectedElements[0], ICICSObject.class.getName());
        if (leftObj != null) {
            ICICSObject rightObj = null;
            rightObj = selectedElements[1] instanceof ICICSObject ? (ICICSObject)selectedElements[1] : (ICICSObject)Platform.getAdapterManager().loadAdapter(selectedElements[1], ICICSObject.class.getName());
            if (leftObj.getObjectType().equals(rightObj.getObjectType())) {
                input = new CompareCICSObjectEditorInput(leftObj, rightObj);
            } else {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Resources cannot be compared", (String)"The selected resource types cannot be compared.");
            }
        } else if (selectedElements[0] instanceof ResourceDefinitionGroup) {
            input = new CompareResourceDefinitionGroupEditorInput((ResourceDefinitionGroup)selectedElements[0], (ResourceDefinitionGroup)selectedElements[1]);
        } else if (selectedElements[0] instanceof ResourceList) {
            input = new CompareResourceListEditorInput((ResourceList)selectedElements[0], (ResourceList)selectedElements[1]);
        }
        try {
            if (input != null) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "com.ibm.cics.cm.compare.editor");
            }
        }
        catch (PartInitException e) {
            logger.log(Level.SEVERE, "Exception opening compare editor", e);
        }
        return null;
    }

    public boolean isEnabled() {
        Object selection;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
            return false;
        }
        IContext context = null;
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        TableView tableView = TableView.getTableViewForIWorkbenchPart((IWorkbenchPart)part);
        if (tableView != null) {
            context = tableView.getContext();
        } else if (part instanceof ResourcesView) {
            context = ((ResourcesView)part).getContext();
        }
        if (!(part instanceof SearchResultsView) && !(part instanceof HistoryView)) {
            Configuration config = null;
            config = !(context instanceof CMContext) ? CMSMConnection.getConfiguration((IContext)context) : ((CMContext)context).getConfiguration();
            if (config == null) {
                return false;
            }
        }
        if ((selection = ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).getActiveLeaf().get("activeMenuSelection")) == null || !(selection instanceof IStructuredSelection)) {
            return false;
        }
        Object[] selectedElements = ((IStructuredSelection)selection).toArray();
        return !(selectedElements[0] instanceof ICICSObject) || !(selectedElements[1] instanceof ICICSObject) || ((ICICSObject)selectedElements[0]).getObjectType().equals(((ICICSObject)selectedElements[1]).getObjectType());
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

