/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.compare.model;

import com.ibm.cics.cm.compare.model.CompareResult;
import com.ibm.cics.cm.compare.model.DetailCompareResult;
import com.ibm.cics.cm.compare.model.DifferenceEngine;
import com.ibm.cics.cm.compare.model.IDifferenceEngine;
import com.ibm.cics.cm.compare.model.Messages;
import com.ibm.cics.cm.compare.model.StructureCompareResult;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.model.ICICSObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.Platform;

final class ResourceGroupDifferenceEngine
extends DifferenceEngine {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    ResourceGroupDifferenceEngine(ResourceDefinitionGroup base) {
        super(base);
    }

    @Override
    public List<CompareResult> diff(String checksumType) {
        ICMDefinition rightDef;
        Map map;
        if (checksumType.equals("NONE")) {
            checksumType = "FULL";
        }
        ArrayList<CompareResult> results = new ArrayList<CompareResult>();
        ResourceDefinitionGroup left = (ResourceDefinitionGroup)this.base;
        String leftChecksum = left.getChecksum(checksumType);
        ResourceDefinitionGroup right = (ResourceDefinitionGroup)this.target;
        String rightChecksum = right.getChecksum(checksumType);
        if (leftChecksum != null && leftChecksum.equals(rightChecksum)) {
            return results;
        }
        IFilteredCollection leftDefinitionsWithChecksum = left.getDefinitionsWithChecksum(checksumType);
        IFilteredCollection rightDefinitionsWthChecksum = right.getDefinitionsWithChecksum(checksumType);
        this.notifyProgress(MessageFormat.format(Messages.ResourceGroupDifferenceEngine_progress, left.getConfiguration().getName(), left.getName()));
        ArrayList leftDefinitions = leftDefinitionsWithChecksum.getResults();
        this.notifyProgress(MessageFormat.format(Messages.ResourceGroupDifferenceEngine_progress, right.getConfiguration().getName(), right.getName()));
        ArrayList rightDefinitions = rightDefinitionsWthChecksum.getResults();
        Map rightMap = CMUtilities.asTypeNameMap((List)rightDefinitions);
        Map leftMap = CMUtilities.asTypeNameMap((List)leftDefinitions);
        TreeSet<String> types = new TreeSet<String>();
        for (ICMDefinition def : leftDefinitions) {
            map = (Map)rightMap.get(def.getType());
            if (map != null && map.containsKey(def.getName())) {
                rightDef = (ICMDefinition)map.get(def.getName());
                if (def.getChecksum().equals(rightDef.getChecksum())) continue;
                types.add(def.getType());
                continue;
            }
            types.add(def.getType());
        }
        for (ICMDefinition def : rightDefinitions) {
            map = (Map)leftMap.get(def.getType());
            if (map != null && map.containsKey(def.getName())) continue;
            types.add(def.getType());
        }
        if (types.isEmpty()) {
            return results;
        }
        this.notifyProgress(Messages.ResourceGroupDifferenceEngine_compareDetailProgress);
        leftDefinitions = new ArrayList();
        rightDefinitions = new ArrayList();
        for (String type : types) {
            leftDefinitionsWithChecksum = left.getDefinitionsWithChecksum(checksumType);
            leftDefinitionsWithChecksum.setObjectType(type);
            leftDefinitionsWithChecksum.setRestrictionCriteriaList(CMUtilities.includeAllAttributes(null, (String)type, (Configuration)left.getConfiguration()));
            leftDefinitions.addAll(leftDefinitionsWithChecksum.getResults());
            rightDefinitionsWthChecksum = right.getDefinitionsWithChecksum(checksumType);
            rightDefinitionsWthChecksum.setRestrictionCriteriaList(CMUtilities.includeAllAttributes(null, (String)type, (Configuration)left.getConfiguration()));
            rightDefinitionsWthChecksum.setObjectType(type);
            rightDefinitions.addAll(rightDefinitionsWthChecksum.getResults());
        }
        rightMap = CMUtilities.asTypeNameMap(rightDefinitions);
        leftMap = CMUtilities.asTypeNameMap(leftDefinitions);
        for (ICMDefinition def : leftDefinitions) {
            map = (Map)rightMap.get(def.getType());
            if (map != null && map.containsKey(def.getName())) {
                IDifferenceEngine differ;
                rightDef = (ICMDefinition)map.get(def.getName());
                if (def.getChecksum().equals(rightDef.getChecksum())) continue;
                ICICSObject leftObj = (ICICSObject)Platform.getAdapterManager().loadAdapter((Object)def, ICICSObject.class.getName());
                ICICSObject rightObj = (ICICSObject)Platform.getAdapterManager().loadAdapter((Object)rightDef, ICICSObject.class.getName());
                if (leftObj == null || rightObj == null || (differ = (IDifferenceEngine)Platform.getAdapterManager().loadAdapter((Object)leftObj, IDifferenceEngine.class.getName())) == null) continue;
                differ.setTarget(rightObj);
                List<CompareResult> childResults = differ.diff(checksumType);
                if (childResults.size() <= 0) continue;
                StructureCompareResult result = new StructureCompareResult(left, right, leftObj, CompareResult.DifferenceType.CHANGED, childResults);
                results.add(result);
                continue;
            }
            DetailCompareResult result = new DetailCompareResult(left, right, def, CompareResult.DifferenceType.ABSENT_FROM_RIGHT){
                private ICICSObject dif;

                @Override
                public Object getDifferingObject() {
                    if (this.dif == null) {
                        this.dif = (ICICSObject)Platform.getAdapterManager().loadAdapter(this.differingObject, ICICSObject.class.getName());
                    }
                    return this.dif;
                }
            };
            results.add(result);
        }
        for (ICMDefinition def : rightDefinitions) {
            map = (Map)leftMap.get(def.getType());
            if (map != null && map.containsKey(def.getName())) continue;
            results.add(new DetailCompareResult(left, right, def, CompareResult.DifferenceType.ABSENT_FROM_LEFT){
                private ICICSObject dif;

                @Override
                public Object getDifferingObject() {
                    if (this.dif == null) {
                        this.dif = (ICICSObject)Platform.getAdapterManager().loadAdapter(this.differingObject, ICICSObject.class.getName());
                    }
                    return this.dif;
                }
            });
        }
        return results;
    }
}

