/******************************************************************************
** 
** Source File Name: sqlstate
** 
** (C) COPYRIGHT International Business Machines Corp. 1991, 1997
** All Rights Reserved
** Licensed Materials - Property of IBM
** 
** US Government Users Restricted Rights - Use, duplication or
** disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
** 
** Function: Include File defining:
**             Labels for the SQL Council's SQL States
** 
** Operating System:  Windows NT
** 
** 
** The last five bytes of the SQLCA contain a diagnostic code called
** SQLSTATE, which is consistent across all IBM SQL products.  The first
** character of SQLSTATE indicates whether the execution of the SQL
** statement was successful or unsuccessful ('0' or not).  The first two
** characters of SQLSTATE represent classes of successful and unsuccessful
** execution conditions (with '00' through '49' reserved for ANS-defined
** classes). The class codes and their meanings are:
** 
** 00  Unqualified Successful Completion
** 01  Warning
** 02  No Data
** 03  SQL Statement Not Yet Complete
** 07  Dynamic SQL Error
** 08  Connection Exception
** 09  Triggered Action Exception
** 0A  Feature Not Supported
** 0D  Invalid Target Type Specification
** 0E  Invalid Schema Name List Specification
** 0F  Invalid Token
** 0W  Resignal When Handler Not Active
** 0W  Prohibited Statement Encounetered During Trigger
** 20  Case Not Found for Case Statement
** 21  Cardinality Violation
** 22  Data Exception
** 23  Constraint Violation
** 24  Invalid Cursor State
** 24  Invalid Transaction State
** 26  Invalid SQL Statement Identifier
** 27  Triggered Data Change Violation
** 28  Invalid Authorization Specification
** 2B  Dependent Privilege Descriptors Still Exist
** 2C  Invalid Character Set Name
** 2D  Invalid Transaction Termination
** 2E  Invalid Connection Name
** 2F  SQL Function Exception
** 33  Invalid SQL Descriptor Name
** 34  Invalid Cursor Name
** 35  Invalid Condition Number
** 37  Syntax Error
** 38  External Function Exception
** 39  External Function Call Exception
** 3B  Savepoint Exception
** 3C  Ambiguous Cursor Name
** 3D  Invalid Catalog Name
** 3E  Invalid Schema (Collection) Name
** 40  Serialization Failure
** 42  Authorization Violation
** 51  Invalid Application State
** 52  Duplicate or Undefined Name
** 53  Invalid Operand or Inconsistent Specification
** 54  SQL or Product Limit Exceeded
** 55  Object Not in Prerequisite State
** 56  Miscellaneous SQL or Product Restriction
** 57  Resource Not Available or Operator Intervention
** 58  System Error
** 
*******************************************************************************/
#ifndef SQL_H_SQLSTATE
#define SQL_H_SQLSTATE

#ifdef __cplusplus
extern "C" {
#endif


/* SQLSTATE CLASSES                                                           */

#define SQLSTATE_CLASS_SUCCESS              "00"
#define SQLSTATE_CLASS_WARNING              "01"
#define SQLSTATE_CLASS_NO_DATA              "02"
#define SQLSTATE_CLASS_CONNECT_EXCEPT       "08"
#define SQLSTATE_CLASS_TRIGGER_EXCEPT       "09"
#define SQLSTATE_CLASS_FEATURE_EXCEPT       "0A"
#define SQLSTATE_CLASS_TYPE_EXCEPT          "0D"
#define SQLSTATE_CLASS_SCHEMA_EXCEPT        "0E"
#define SQLSTATE_CLASS_INVALID_TOKEN        "0F"
#define SQLSTATE_CLASS_TRIG_PROHIBIT        "0W"
#define SQLSTATE_CLASS_CASE_EXCEPT          "20"
#define SQLSTATE_CLASS_CARDINALITY          "21"
#define SQLSTATE_CLASS_DATA_EXCEPT          "22"
#define SQLSTATE_CLASS_CONSTRAINT           "23"
#define SQLSTATE_CLASS_INV_CURS_STATE       "24"
#define SQLSTATE_CLASS_INV_STMT_ID          "26"
#define SQLSTATE_CLASS_SYNTAX               "37"
#define SQLSTATE_CLASS_SERIALIZATION        "40"
#define SQLSTATE_CLASS_AUTHORZATION         "42"
#define SQLSTATE_CLASS_INV_APP_STATE        "51"
#define SQLSTATE_CLASS_DUP_UNDEF_NAME       "52"
#define SQLSTATE_CLASS_INV_OPERAND          "53"
#define SQLSTATE_CLASS_LIMIT                "54"
#define SQLSTATE_CLASS_PREREQ_STATE         "55"
#define SQLSTATE_CLASS_MISC_RESTRICT        "56"
#define SQLSTATE_CLASS_RESOURCE             "57"
#define SQLSTATE_CLASS_SYSTEM_ERROR         "58"

/* SQLSTATES                                                                  */

#define SQL_EXEC_OK                         "00000"
#define SQL_WARN_DISCONNECT_ERR             "01002"
#define SQL_WARN_NULL_VAL_ELIMINATED        "01003"
#define SQL_WARN_VAL_TRUNC                  "01004"
#define SQL_WARN_INSUFF_ITEM_DESCRIPT       "01005"
#define SQL_WARN_NOT_ALL_PRIVS_GRANTED      "01007"
#define SQL_STATE_0100C                     "0100C"
#define SQL_STATE_0100D                     "0100D"
#define SQL_STATE_0100E                     "0100E"
#define SQL_WARN_STR_TRUNC                  "01501"
#define SQL_WARN_NULLS_ELIM                 "01502"
#define SQL_WARN_COLS_TOOMANY               "01503"
#define SQL_WARN_STMT_NOWHERE               "01504"
#define SQL_WARN_STMT_NOTEXEC               "01505"
#define SQL_WARN_DATE_ADJ                   "01506"
#define SQL_WARN_CURSOR_NOT_BLOCKED         "01509"
#define SQL_WARN_HOST_NULL_COL_RANGE        "01515"
#define SQL_WARN_WITH_GRANT_IGNORED         "01516"
#define SQL_WARN_CHAR_SUB                   "01517"
#define SQL_WARN_HOST_NULL_NUM_RANGE        "01519"
#define SQL_WARN_VAR_NOWNULL                "01520"
#define SQL_WARN_TABLE_UNDEF                "01522" /* Planned                */
#define SQL_WARN_NULLS2_ELIM                "01524"
#define SQL_WARN_NUM_INSERTS_INVALID        "01525"
#define SQL_WARN_ISO_ESCAL                  "01526"
#define SQL_WARN_REG_NOTEXIST               "01527" /* Planned                */
#define SQL_WARN_WHERE_IGNORE               "01528" /* Planned                */
#define SQL_WARN_NAME_UNDEF                 "01532"
#define SQL_WARN_UNDEFINED_COLUMN_NAME      "01533"
#define SQL_WARN_USE_SBCS_CHARS_ONLY        "01539"
#define SQL_STATE_01541I                    "01541"
#define SQL_WARN_OP_NOPRIV                  "01542"
#define SQL_WARN_REF_IGNORE                 "01543"
#define SQL_WARN_NAME_INTERP                "01545"
#define SQL_WARN_OBJ_NOPRIV                 "01548"
#define SQL_WARN_PACK_PRIV                  "01549" /* Planned                */
#define SQL_WARN_INDEX_EXIST                "01550"
#define SQL_WARN_GRANT_IGNORED              "01560"
#define SQL_WARN_NEWLOGPATH_INV             "01562"
#define SQL_WARN_CURR_LOGPATH_INV           "01563"
#define SQL_WARN_HOST_NULL_DIV_ZERO         "01564"
#define SQL_WARN_DECFLOAT_SNAN              "01565"
#define SQL_WARN_VAL_INCMPAT_WITH_COL       "01580"
#define SQL_WARN_AUTO_CHECK_PEND_STATE      "01586"
#define SQL_WARN_KEYWORD_REDUNDANT          "01589"
#define SQL_WARN_VAL_MAY_BE_TRUNC           "01592"
#define SQL_WARN_VAL_COULD_BE_TRUNC         "01593"
#define SQL_WARN_INSUFF_DESCRIPTORS         "01594"
#define SQL_WARN_OLD_VIEW_REPLACED          "01595"
#define SQL_WARN_NO_COMPFUNC_FOR_LSTR       "01596"
#define SQL_WARN_EVMON_STATE_NOT_SET        "01598"
#define SQL_WARN_REBIND_OPTS_IGNORED        "01599"
#define SQL_WARN_CONN_DISABLED              "01601"
#define SQL_WARN_SUB_OPTIMAL_QUERY          "01602"
#define SQL_WARN_CONSTRAINT_VIO_MOVED       "01603"
#define SQL_WARN_EXPLAIN_MODE_RESTRICT      "01604"
#define SQL_WARN_POSSIBLE_INFINIT_LOOP      "01605"
#define SQL_WARN_DIR_EMPTY                  "01606"
#define SQL_WARN_TIMEDIFF_EXCEEDED          "01607"
#define SQL_WARN_CLAUSE_VAL_REPLACED        "01608"
#define SQL_WARN_MAX_QUERY_RESULT_SET       "01609"
#define SQL_WARN_MORE_RESULT_SETS           "01610"
#define SQL_WARN_NEXT_RESULT_SET            "01611"
#define SQL_STATE_01614                     "01614"
#define SQL_WARN_COST_EXCEED_LIMIT          "01616"
#define SQL_WARN_REDIST_REQUIRED            "01618"
#define SQL_WARN_UNIONALL_TABLES_SAME       "01620"
#define SQL_WARN_LOB_CHANGED                "01621"
#define SQL_WARN_SYSTEM_ERROR               "01622"
#define SQL_WARN_DEGREE_IGNORED             "01623"
#define SQL_STATE_01625                     "01625"
#define SQL_WARN_ONE_ACTIVE_BUFFPOOL        "01626"
#define SQL_WARN_DATALINK_VAL_INVAL         "01627"
#define SQL_WARN_RESOURCE_UNAVAIL           "01630"
#define SQL_NUM_CONN_EXCEEDED               "01632"
#define SQL_SUMM_TABLE_NO_OPTIMIZE          "01633"
#define SQL_INTEGRITY_UNVERIFIED            "01636"
#define SQL_DEBUGGER_NOT_ENABLED            "01637"
#define SQL_STATE_01639                     "01639"
#define SQL_STATE_01641                     "01641"
#define SQL_STATE_01642                     "01642"
#define SQL_STATE_01643                     "01643"
#define SQL_STATE_01645                     "01645"
#define SQL_STATE_01648                     "01648"
#define SQL_STATE_01649                     "01649"
#define SQL_STATE_01650                     "01650"
#define SQL_STATE_01651                     "01651"
#define SQL_STATE_01652                     "01652"
#define SQL_STATE_01653                     "01653"
#define SQL_STATE_01654                     "01654"
#define SQL_STATE_01655                     "01655"
#define SQL_STATE_01657                     "01657"
#define SQL_WARN_INDEX_UNIQUE               "01661"
#define SQL_STATE_01665                     "01665"
#define SQL_STATE_01667                     "01667"
#define SQL_STATE_01669                     "01669"
#define SQL_STATE_01670                     "01670"
#define SQL_STATE_01671                     "01671"
#define SQL_WARN_TBSP_NOT_OPTIMAL           "01674"
#define SQL_WARN_TOO_MANY_TBSP              "01675"
#define SQL_STATE_01676                     "01676"
#define SQL_STATE_01677                     "01677"
#define SQL_STATE_01678                     "01678"
#define SQL_STATE_01679                     "01679"
#define SQL_STATE_01682                     "01682"
#define SQL_STATE_01684                     "01684"
#define SQL_STATE_01686                     "01686"
#define SQL_STATE_01689                     "01689"
#define SQL_STATE_0168A                     "0168A"
#define SQL_STATE_0168B                     "0168B"
#define SQL_STATE_0168C                     "0168C"
#define SQL_STATE_0168D                     "0168D"
#define SQL_STATE_0168E                     "0168E"
#define SQL_STATE_0168F                     "0168F"
#define SQL_STATE_0168H                     "0168H"
#define SQL_STATE_0168J                     "0168J"
#define SQL_STATE_0168M                     "0168M"
#define SQL_STATE_0168O                     "0168O"
#define SQL_STATE_0168Q                     "0168Q"
#define SQL_STATE_0168S                     "0168S"
#define SQL_STATE_0168T                     "0168T"
#define SQL_STATE_0168V                     "0168V"
#define SQL_STATE_0168W                     "0168W"
#define SQL_STATE_0168Y                     "0168Y"
#define SQL_STATE_01690                     "01690"
#define SQL_STATE_01691                     "01691"
#define SQL_STATE_01694                     "01694"
#define SQL_STATE_01695                     "01695"
#define SQL_STATE_01696                     "01696"
#define SQL_STATE_01698                     "01698"
#define SQL_STATE_01699                     "01699"
#define SQL_STATE_0169C                     "0169C"
#define SQL_STATE_0169E                     "0169E"
#define SQL_STATE_0169I                     "0169I"
#define SQL_STATE_0169J                     "0169J"
#define SQL_WARN_INVALID_CURSOR_POS         "01S06"
#define SQL_WARN_UDF_RETURNS_STATE          "01Hxx"
#define SQL_STATE_01H52                     "01H52"
#define SQL_STATE_01H53                     "01H53"
#define SQL_STATE_01H54                     "01H54"
#define SQL_STATE_01H55                     "01H55"
#define SQL_STATE_01H56                     "01H56"
#define SQL_STATE_01H57                     "01H57"
#define SQL_STATE_01H58                     "01H58"
#define SQL_STATE_01H59                     "01H59"
#define SQL_STATE_01H5B                     "01H5B"
#define SQL_STATE_01HN0                     "01HN0"
#define SQL_STATE_01HN1                     "01HN1"
#define SQL_STATE_01HN2                     "01HN2"
#define SQL_WARN_01HS0                      "01HS0"
#define SQL_WARN_01HS1                      "01HS1"
#define SQL_WARN_01HS2                      "01HS2"
#define SQL_WARN_01HS3                      "01HS3"
#define SQL_WARN_0169K                      "0169K"
#define SQL_NODATA_EXCEPTION                "02000"
#define SQL_NODATA_UHOLE                    "02501"
#define SQL_NODATA_DHOLE                    "02502"
#define SQL_STATE_02506                     "02506"
#define SQL_INV_NUM_HOST_VARS               "07001"
#define SQL_INV_PARM_OR_CB                  "07002"
#define SQL_INV_EXECUTE_STMT                "07003"
#define SQL_USING_CLAUSE_REQUIRED           "07004"
#define SQL_INV_PREP_STMT_CURSOR            "07005"
#define SQL_HOSTVAR_NOT_USABLE              "07006"
#define SQL_STATE_07007                     "07007"
#define SQL_CONN_FAILED                     "08001"
#define SQL_CONN_ALREADY_EXIST              "08002"
#define SQL_CONN_DOES_NOT_EXIT              "08003"
#define SQL_CONN_REJECTED_BY_SERVER         "08004"
#define SQL_CONN_RESOLUTION_UNKNOWN         "08007"
#define SQL_CONN_FAILED_NO_TM               "08502"
#define SQL_STATE_08504                     "08504"
#define SQL_STATE_08506                     "08506"
#define SQL_STATE_08507                     "08507"
#define SQL_STATE_08508                     "08508"
#define SQL_TRIGGER_ERROR                   "09000"
#define SQL_PROC_NOT_CONNECTABLE            "0A001"
#define SQL_INSTANCE_NOT_ENABLED            "0A502"
#define SQL_STATE_0A503                     "0A503"
#define SQL_STATE_0D000                     "0D000"
#define SQL_STATE_0E000                     "0E000"
#define SQL_LOB_NOVALUE_TOKEN_VAR           "0F001"
#define SQL_STATE_0K000                     "0K000"
#define SQL_STATE_0N002                     "0N002"
#define SQL_STATE_0W000                     "0W000"
#define SQL_STATE_10501                     "10501"
#define SQL_STATE_10502                     "10502"
#define SQL_STATE_10503                     "10503"
#define SQL_STATE_10504                     "10504"
#define SQL_STATE_10505                     "10505"
#define SQL_STATE_10506                     "10506"
#define SQL_STATE_10507                     "10507"
#define SQL_STATE_10508                     "10508"
#define SQL_STATE_10509                     "10509"
#define SQL_STATE_10510                     "10510"
#define SQL_STATE_10601                     "10601"
#define SQL_STATE_10602                     "10602"
#define SQL_STATE_10603                     "10603"
#define SQL_STATE_10604                     "10604"
#define SQL_STATE_10605                     "10605"
#define SQL_STATE_10606                     "10606"
#define SQL_STATE_10607                     "10607"
#define SQL_STATE_10608                     "10608"
#define SQL_STATE_10609                     "10609"
#define SQL_STATE_10610                     "10610"
#define SQL_STATE_10611                     "10611"
#define SQL_STATE_10701                     "10701"
#define SQL_STATE_10702                     "10702"
#define SQL_STATE_10703                     "10703"
#define SQL_STATE_10704                     "10704"
#define SQL_STATE_10705                     "10705"
#define SQL_STATE_10706                     "10706"
#define SQL_STATE_10707                     "10707"
#define SQL_STATE_10708                     "10708"
#define SQL_STATE_10709                     "10709"
#define SQL_STATE_10901                     "10901"
#define SQL_STATE_10902                     "10902"
#define SQL_STATE_10903                     "10903"
#define SQL_STATE_20000                     "20000"
#define SQL_CARD_VALUE_TOOMANY              "21000"
#define SQL_CARD_INS_MULTIROW               "21501"
#define SQL_CARD_UPD_MULTIROW               "21502"
#define SQL_CARD_DEL_MULTIROW               "21504"
#define SQL_DATA_ONE_ROW                    "21505"
#define SQL_STATE_21506                     "21506"
#define SQL_DATA_CHAR_RTRUNC                "22001"
#define SQL_DATA_INDICATOR_NULL             "22002"
#define SQL_DATA_NUM_RANGE                  "22003"
#define SQL_STATE_22004                     "22004"
#define SQL_DATA_FETCH_INV                  "22006" /* Planned                */
#define SQL_DATA_FORMAT_INV                 "22007"
#define SQL_STATE_22007                     "22007"
#define SQL_DATA_DATETIME_OV                "22008"
#define SQL_STATE_2200G                     "2200G"
#define SQL_STATE_2200L                     "2200L"
#define SQL_STATE_2200M                     "2200M"
#define SQL_STATE_2200S                     "2200S"
#define SQL_STATE_2200T                     "2200T"
#define SQL_STATE_2200W                     "2200W"
#define SQL_STATE_22010                     "22010"
#define SQL_DATA_STR_RANGE                  "22011"
#define SQL_DATA_DIV_ZERO                   "22012"
#define SQL_DATA_INV_CAST_CHAR              "22018"
#define SQL_STATE_22014                     "22014"
#define SQL_STATE_22016                     "22016"
#define SQL_STATE_22018                     "22018"
#define SQL_DATA_LIKE_INV_CHAR              "22019" /* Planned                */
#define SQL_STATE_2201G                     "2201G"
#define SQL_STATE_2201S                     "2201S"
#define SQL_STATE_2201T                     "2201T"
#define SQL_STATE_2201V                     "2201V"
#define SQL_STATE_2201W                     "2201W"
#define SQL_STATE_2201X                     "2201X"
#define SQL_STATE_22021                     "22021"
#define SQL_DATA_NULL_MISSING               "22024"
#define SQL_DATA_LIKE_INV_ESC               "22025"
#define SQL_NULL_INSTANCE_MUT               "2202D"
#define SQL_STATE_2202E                     "2202E"
#define SQL_STATE_2202F                     "2202F"
#define SQL_STATE_2202H                     "2202H"
#define SQL_STATE_22032                     "22032"
#define SQL_STATE_22035                     "22035"
#define SQL_STATE_22037                     "22037"
#define SQL_STATE_2203A                     "2203A"
#define SQL_STATE_2203F                     "2203F"
#define SQL_DATA_LENGTH_RANGE               "22501"
#define SQL_DATA_STR_INV                    "22503"
#define SQL_DATA_DATA_BADFORM               "22504"
#define SQL_DATA_DATETIME_REG_INV           "22506"
#define SQL_DATA_TYPE_CANTUSE               "22507"
#define SQL_DATA_TYPE_INCOMPAT              "22509"
#define SQL_HOSTVAR_NEG_INDVAR              "22512"
#define SQL_DATA_INDEX_DUP                  "22515"
#define SQL_DATA_STR_CANTUSE_XLATE          "22517"
#define SQL_DATA_STR_CANTASGN_XLATE         "22518"
#define SQL_DATA_KEY_NOTEQUAL               "22520"
#define SQL_DATA_CCSIDVAL_INV               "22522"
#define SQL_DATA_CONVERSION_TRUNC           "22524"
#define SQL_DATAPART_KEY_INVALID            "22525"
#define SQL_STATE_22526                     "22526"
#define SQL_STATE_22527                     "22527"
#define SQL_STATE_22531                     "22531"
#define SQL_STATE_22532                     "22532"
#define SQL_STATE_22533                     "22533"
#define SQL_STATE_22534                     "22534"
#define SQL_STATE_22535                     "22535"
#define SQL_STATE_22536                     "22536"
#define SQL_STATE_22538                     "22538"
#define SQL_STATE_22539                     "22539"
#define SQL_STATE_22540                     "22540"
#define SQL_STATE_22541                     "22541"
#define SQL_STATE_22542                     "22542"
#define SQL_STATE_22544                     "22544"
#define SQL_STATE_22545                     "22545"
#define SQL_STATE_22546                     "22546"
#define SQL_STATE_22547                     "22547"
#define SQL_STATE_22548                     "22548"
#define SQL_STATE_22549                     "22549"
#define SQL_STATE_22550                     "22550"
#define SQL_STATE_22551                     "22551"
#define SQL_STATE_225D1                     "225D1"
#define SQL_STATE_225D2                     "225D2"
#define SQL_STATE_225D3                     "225D3"
#define SQL_STATE_225D4                     "225D4"
#define SQL_STATE_225D5                     "225D5"
#define SQL_STATE_225D6                     "225D6"
#define SQL_STATE_225D7                     "225D7"
#define SQL_STATE_225DE                     "225DE"
#define SQL_STATE_225X0                     "225X0"
#define SQL_CONSTR_CHG_KEY_NOTALLOW         "23001"
#define SQL_CONSTR_ROW_NOTSATISFY_VIEW      "23501"
#define SQL_CONSTR_NULL_NOTALLOW            "23502"
#define SQL_CONSTR_VALUE_INV                "23503"
#define SQL_CONSTR_OP_RESTRICT              "23504"
#define SQL_CONSTR_INDEX_UNIQUE             "23505"
#define SQL_CONSTR_VIOLATION_RLST           "23510"
#define SQL_CONSTR_PAR_ROW_DEL_NOALLOW      "23511"
#define SQL_CONSTR_ROW_INVALID              "23512"
#define SQL_CONSTR_ROW_NONCONFORM           "23513"
#define SQL_CONSTR_VIOLATIONS               "23514"
#define SQL_CONSTR_DUP_KEY_VALUES           "23515"
#define SQL_CONSTR_FOREIGN_KEY_NOALLOW      "23520"
#define SQL_CONSTR_UPDATE_CAT_STATS         "23521"
#define SQL_IDENTITY_EXHAUSTED              "23522"
#define SQL_STATE_23523                     "23523"
#define SQL_STATE_23524                     "23524"
#define SQL_STATE_23525                     "23525"
#define SQL_STATE_23526                     "23526"
#define SQL_STATE_23527                     "23527"
#define SQL_STATE_23528                     "23528"
#define SQL_CURSOR_NOTOPEN                  "24501"
#define SQL_CURSOR_OPEN_ALREADY             "24502"
#define SQL_CURSOR_NOTPOS                   "24504"
#define SQL_CURSOR_OPEN_NO_COMMIT           "24505"
#define SQL_CURSOR_PD_OPEN                  "24506"
#define SQL_CURSOR_DELETED                  "24507" /* Planned                */
#define SQL_CURSOR_DHOLE                    "24510"
#define SQL_CURSOR_UHOLE                    "24511" /* Planned                */
#define SQL_CURSOR_AGREE                    "24512" /* Planned                */
#define SQL_CURSOR_MOVED                    "24513"
#define SQL_CURSOR_PREVIOUS_ERROR           "24514"
#define SQL_CURSOR_ALREADY_ASSIGNED         "24516"
#define SQL_STATE_24517                     "24517"
#define SQL_STATE_24525                     "24525"
#define SQL_INV_EXECUTION_ENVIRONMENT       "25000" /* Planned                */
#define SQL_STATE_25001                     "25001"
#define SQL_ONLY_AS_FIRST_STATEMENT         "25501" /* Planned                */
#define SQL_MULTIPLE_OPERATIONS             "25502"
#define SQL_IDENT_NOTEXIST                  "26501"
#define SQL_IDENT_NOASSOC                   "26503"
#define SQL_IDENT_SELECT                    "26504"
#define SQL_IDENT_NOTSPEC                   "26506" /* Planned                */
#define SQL_IDENT_NOTSRSEL                  "26507"
#define SQL_IDENT_NOTSELECT                 "26508" /* Planned                */
#define SQL_IDENT_DUP                       "26509" /* Planned                */
#define SQL_IDENT_HASCURSOR                 "26510" /* Planned                */
#define SQL_STATE_27000                     "27000"
#define SQL_INV_AUTHORIZATION_SPEC          "28000"
#define SQL_INV_OPERATION_FOR_ENVIR         "2D521"
#define SQL_STATE_2D522                     "2D522"
#define SQL_DYNAMIC_COMMIT_INVALID          "2D528"
#define SQL_DYNAMIC_ROLLBACK_INVALID        "2D529"
#define SQL_INV_CONN_NAME                   "2E000"
#define SQL_INV_CURSOR_NAME                 "34000"
#define SQL_STATE_36001                     "36001"
#define SQL_SYNTAX_TOKEN_MISSING            "37501"
#define SQL_SYNTAX_NAME_INVCHAR             "37502"
#define SQL_SYNTAX_STR_UNTERM               "37503"
#define SQL_SYNTAX_CONST_INV                "37504"
#define SQL_SYNTAX_NUMARGS_INV              "37505"
#define SQL_SYNTAX_HCONST_INV               "37506" /* Planned                */
#define SQL_SYNTAX_OP_INV_COL               "37507"
#define SQL_SYNTAX_OP_MARKER                "37509"
#define SQL_SYNTAX_MARKER_INV               "37510"
#define SQL_SYNTAX_COL_INV                  "37511"
#define SQL_SYNTAX_STMT_BAD                 "37512"
#define SQL_SYNTAX_CLAUSE_EXCLUSIVE         "37513" /* Planned                */
#define SQL_SYNTAX_KEYWORD_DUP              "37514"
#define SQL_SYNTAX_OPT_INV                  "37516" /* Planned                */
#define SQL_SYNTAX_STMT_EMPTY               "37517"
#define SQL_SYNTAX_HOSTVAR_NOTALLOW         "37518"
#define SQL_SYNTAX_READONLY_NOTALLOW        "37520" /* Planned                */
#define SQL_UDF_RETURNS_ERROR_STATE         "38xxx"
#define SQL_UDF_SQL_NOT_ALLOWED             "38001"
#define SQL_UDF_MODIFIES_NOT_ALLOWED        "38002"
#define SQL_UDF_STMT_NOT_ALLOWED            "38003"
#define SQL_UDF_READS_NOT_ALLOWED           "38004"
#define SQL_UDF_CALL_ERROR                  "38501"
#define SQL_UDF_EXCUTE_SQL_NOTALLOW         "38502"
#define SQL_UDF_ABNORMAL_END                "38503"
#define SQL_UDF_INTERRUPTED                 "38504"
#define SQL_STATE_38505                     "38505"
#define SQL_STATE_38506                     "38506"
#define SQL_STATE_38553                     "38553"
#define SQL_STATE_38554                     "38554"
#define SQL_STATE_TXTSRCH_QRY_GENERAL       "38H10"
#define SQL_STATE_TXTSRCH_QRY_UNAVAIL       "38H11"
#define SQL_STATE_TXTSRCH_QRY_NOINDEX       "38H12"
#define SQL_STATE_TXTSRCH_OP_CONFLICT       "38H13"
#define SQL_STATE_TXTSRCH_OP_GENERAL        "38H14"
#define SQL_STATE_38S01                     "38S01"
#define SQL_STATE_38S02                     "38S02"
#define SQL_STATE_38S03                     "38S03"
#define SQL_STATE_38S04                     "38S04"
#define SQL_STATE_38S53                     "38S53"
#define SQL_STATE_38S56                     "38S56"
#define SQL_STATE_38S5E                     "38S5E"
#define SQL_STATE_38S69                     "38S69"
#define SQL_STATE_38SP5                     "38SP5"
#define SQL_STATE_38S5K                     "38S5K"
#define SQL_STATE_38S64                     "38S64"
#define SQL_STATE_38SS0                     "38SS0"
#define SQL_STATE_38SS2                     "38SS2"
#define SQL_STATE_38SS3                     "38SS3"
#define SQL_STATE_38SS5                     "38SS5"
#define SQL_STATE_38SS6                     "38SS6"
#define SQL_STATE_38SS7                     "38SS7"
#define SQL_STATE_38SS8                     "38SS8"
#define SQL_STATE_38SS9                     "38SS9"
#define SQL_STATE_38SSA                     "38SSA"
#define SQL_STATE_38SSB                     "38SSB"
#define SQL_STATE_38SSC                     "38SSC"
#define SQL_STATE_38SSD                     "38SSD"
#define SQL_STATE_38SSE                     "38SSE"
#define SQL_STATE_38SSF                     "38SSF"
#define SQL_STATE_38SSG                     "38SSG"
#define SQL_STATE_38SSH                     "38SSH"
#define SQL_STATE_38SSI                     "38SSI"
#define SQL_STATE_38SSJ                     "38SSJ"
#define SQL_STATE_38SSK                     "38SSK"
#define SQL_STATE_38SSL                     "38SSL"
#define SQL_STATE_38SSM                     "38SSM"
#define SQL_STATE_38SSN                     "38SSN"
#define SQL_STATE_38SSO                     "38SSO"
#define SQL_STATE_38SSP                     "38SSP"
#define SQL_STATE_38SSQ                     "38SSQ"
#define SQL_STATE_38SSR                     "38SSR"
#define SQL_STATE_38SSS                     "38SSS"
#define SQL_STATE_38SST                     "38SST"
#define SQL_STATE_38SSU                     "38SSU"
#define SQL_STATE_38SSV                     "38SSV"
#define SQL_STATE_38SSW                     "38SSW"
#define SQL_STATE_38SSX                     "38SSX"
#define SQL_STATE_38SU1                     "38SU1"
#define SQL_STATE_38SU2                     "38SU2"
#define SQL_STATE_38SU3                     "38SU3"
#define SQL_STATE_38SU4                     "38SU4"
#define SQL_STATE_38SU5                     "38SU5"
#define SQL_STATE_38SU7                     "38SU7"
#define SQL_STATE_38SU9                     "38SU9"
#define SQL_STATE_38SUC                     "38SUC"
#define SQL_STATE_38SUD                     "38SUD"
#define SQL_STATE_38SUE                     "38SUE"
#define SQL_STATE_38SUF                     "38SUF"
#define SQL_STATE_38SUK                     "38SUK"
#define SQL_STATE_38SUL                     "38SUL"
#define SQL_STATE_38SUM                     "38SUM"
#define SQL_STATE_38SUO                     "38SUO"
#define SQL_STATE_38SUP                     "38SUP"
#define SQL_STATE_38SUQ                     "38SUQ"
#define SQL_STATE_38SUR                     "38SUR"
#define SQL_STATE_38SUS                     "38SUS"
#define SQL_STATE_38SUV                     "38SUV"
#define SQL_STATE_38SUW                     "38SUW"
#define SQL_STATE_38SUX                     "38SUX"
#define SQL_STATE_38SUY                     "38SUY"
#define SQL_STATE_38SUZ                     "38SUZ"
#define SQL_STATE_38SV0                     "38SV0"
#define SQL_STATE_38SV4                     "38SV4"
#define SQL_STATE_38SV5                     "38SV5"
#define SQL_STATE_38SV6                     "38SV6"
#define SQL_STATE_38SV7                     "38SV7"
#define SQL_STATE_38SV8                     "38SV8"
#define SQL_STATE_38SV9                     "38SV9"
#define SQL_STATE_38SVA                     "38SVA"
#define SQL_STATE_38SVB                     "38SVB"
#define SQL_STATE_38SVC                     "38SVC"
#define SQL_UDF_RETURNS_INV_STATE           "39001"
#define SQL_STATE_39004                     "39004"
#define SQL_UDF_RETURNS_RESULT_TOOLONG      "39501"
#define SQL_OUT_SQLDA_CHANGED               "39502"
#define SQL_STATE_3B001                     "3B001"
#define SQL_STATE_3B002                     "3B002"
#define SQL_STATE_3B501                     "3B501"
#define SQL_STATE_3B502                     "3B502"
#define SQL_STATE_3B503                     "3B503"
#define SQL_SERIAL_ROLLBACK                 "40000"
#define SQL_ROLLBK_AUTOMATIC                "40001"
#define SQL_STMT_COMPLETION_UNKNOWN         "40003"
#define SQL_ROLLBK_DIST_ENV                 "40502"
#define SQL_ROLLBK_CONN_LOST                "40504"
#define SQL_ROLLBK_TABLE                    "40506"
#define SQL_STATE_40507                     "40507"
#define SQL_ACCESS_AUTH_NOTPRIV_OBJ         "42501"
#define SQL_ACCESS_AUTH_NOTPRIV_OP          "42502"
#define SQL_ACCESS_AUTH_NOT_AUTHORIZED      "42503"
#define SQL_ACCESS_PRIV_CANTREVOKE          "42504"
#define SQL_ACCESS_AUTH_FAIL_CONNECTION     "42505"
#define SQL_ACCESS_AUTH_FAIL_OWNER          "42506"
#define SQL_ACCESS_AUTH_FAIL_SERVER         "42507"
#define SQL_ACCESS_PRIV_CANTPUBLIC          "42508"
#define SQL_STAT_NOT_AUTH_STATICRULES       "42509"
#define SQL_STATE_42511                     "42511"
#define SQL_STATE_42516                     "42516"
#define SQL_STATE_42517                     "42517"
#define SQL_STATE_42512                     "42512"
#define SQL_STATE_42519                     "42519"
#define SQL_STATE_42521                     "42521"
#define SQL_STATE_42522                     "42522"
#define SQL_STATE_42524                     "42524"
#define SQL_STATE_42525                     "42525"
#define SQL_STATE_42526                     "42526"
#define SQL_SYNTAX_KEYWORD_INCOMPAT         "42601"
#define SQL_SYNTAX_INVALID                  "42601"
#define SQL_INVALID_CHAR_IN_NAME            "42602"
#define SQL_UNTERMINATED_STRING_CONST       "42603"
#define SQL_INVALID_NUM_OR_STR_CONST        "42604"
#define SQL_INVALID_NUM_ARGS                "42605"
#define SQL_INVALID_HEX_CONST               "42606"
#define SQL_INVALID_COL_FUNC_OPERAND        "42607"
#define SQL_INV_USE_OF_NULL_OR_DFLT         "42608"
#define SQL_ALL_OPERANDS_PARM_MARKERS       "42609"
#define SQL_PARAMETER_MARKERS_INVALID       "42610"
#define SQL_SYNTAX_LEN_SCALE_INV            "42611"
#define SQL_STMT_NOT_IN_CONTEXT             "42612"
#define SQL_SYNTAX_KEYWORD_CONFLICT         "42613"
#define SQL_DUP_KEYWORD_INV                 "42614"
#define SQL_INV_ALTERNATIVE                 "42615"
#define SQL_STATE_42616                     "42616"
#define SQL_STMT_STR_BLANK_OR_EMPTY         "42617"
#define SQL_HOST_VAR_NOT_ALLOWED            "42618"
#define SQL_STATE_42620                     "42620"
#define SQL_CHECK_CONSTRAINT_INVALID        "42621"
#define SQL_NAME_OR_LABEL_IS_TOO_LONG       "42622"
#define SQL_IDENTITY_NO_DEFAULT             "42623"
#define SQL_CASE_RES_NOT_EXPRESSION         "42625"
#define SQL_RETURNS_EXPR_AS                 "42627"
#define SQL_STATE_42628                     "42628"
#define SQL_STATE_42629                     "42629"
#define SQL_STATE_42630                     "42630"
#define SQL_STATE_42631                     "42631"
#define SQL_STATE_42632                     "42632"
#define SQL_STATE_42633                     "42633"
#define SQL_STATE_42634                     "42634"
#define SQL_STATE_42635                     "42635"
#define SQL_STATE_42636                     "42636"
#define SQL_STATE_42637                     "42637"
#define SQL_STATE_42638                     "42638"
#define SQL_STATE_42639                     "42639"
#define SQL_DUP_COL_IN_INS_OR_UPD           "42701"
#define SQL_COLUMN_NAME_AMBIGUOUS           "42702"
#define SQL_UNDEFINED_COLUMN_NAME           "42703"
#define SQL_NAME_OBJECT_UNDEF               "42704"
#define SQL_NAME_SERVER_UNDEFINED           "42705"
#define SQL_UNNAMED_COLS_IN_RESULT_TBL      "42706"
#define SQL_NAME_NOT_IN_RESULT_TABLE        "42707"
#define SQL_NAME_DUP_COL_IN_KEY             "42709"
#define SQL_NAME_DUP_OBJ_NAME               "42710"
#define SQL_NAME_DUP_COL_NAME               "42711"
#define SQL_NAME_DUP_IN_FROM_CLAUSE         "42712"
#define SQL_DUP_OBJECT_IN_LIST              "42713"
#define SQL_NAME_NODE_NOT_FOUND_IN_DIR      "42720"
#define SQL_NAME_DUP_SIGNATURE              "42723"
#define SQL_ACCESS_UNABLE                   "42724"
#define SQL_NAME_AMBIGUOUS                  "42725"
#define SQL_DUP_DERIVED_TABLE_NAME          "42726"
#define SQL_NEED_DEFAULT_PRIM_TBLSPACE      "42727"
#define SQL_ACCESS_DUPLICATE_NODE           "42728"
#define SQL_ACCESS_UNDEFINED_NODE           "42729"
#define SQL_CONTNR_NAME_USEDBY_ANOTHER      "42730"
#define SQL_CONTNR_NAME_USED                "42731"
#define SQL_DUP_SCHEMA_NAME_IN_PATH         "42732"
#define SQL_STATE_42734                     "42734"
#define SQL_NODEGROUP_NOT_DEFINED           "42735"
#define SQL_STATE_42736                     "42736"
#define SQL_STATE_42737                     "42737"
#define SQL_STATE_42738                     "42738"
#define SQL_TRANSFORM_EXISTS                "42739"
#define SQL_NO_TRANSFORM_DROPPED            "42740"
#define SQL_TRANSFORM_NOT_FOUND             "42741"
#define SQL_SUBTABLE_EXISTS                 "42742"
#define SQL_METHOD_NOT_FOUND                "42743"
#define SQL_STATE_42744                     "42744"
#define SQL_STATE_42745                     "42745"
#define SQL_STATE_42746                     "42746"
#define SQL_DUPLICATE_STORAGE_PATH          "42748"
#define SQL_STATE_42749                     "42749"
#define SQL_STATE_4274A                     "4274A"
#define SQL_STATE_4274B                     "4274B"
#define SQL_STATE_4274C                     "4274C"
#define SQL_STATE_4274D                     "4274D"
#define SQL_STATE_4274F                     "4274F"
#define SQL_STATE_4274G                     "4274G"
#define SQL_STATE_4274H                     "4274H"
#define SQL_STATE_4274I                     "4274I"
#define SQL_STATE_4274J                     "4274J"
#define SQL_STATE_4274K                     "4274K"
#define SQL_STATE_4274L                     "4274L"
#define SQL_STATE_4274M                     "4274M"
#define SQL_STATE_4274O                     "4274O"
#define SQL_INVALID_STRING_LEN_UNIT         "428GC"
#define SQL_NUM_INSERTS_INVALID             "42802"
#define SQL_COLUMN_REF_INVALID              "42803"
#define SQL_CASE_RES_NOT_COMPATIBLE         "42804"
#define SQL_ORDER_BY_INT_NOT_IN_RESULT      "42805"
#define SQL_DATA_TYPES_INCOMPAT             "42806"
#define SQL_OPERATION_NOTPERMIT_ON_OBJ      "42807"
#define SQL_COLUMN_NOT_UPDATEABLE           "42808"
#define SQL_STATEMENT_NOT_APPLICABLE        "42809"
#define SQL_FOREIGN_KEY_HAS_VIEW            "42810"
#define SQL_NUM_COLS_NOT_MATCH_SELECT       "42811"
#define SQL_VIEW_NOTALLOW_WITH_CHECK        "42813"
#define SQL_SYNTAX_LANG_TYPE_INV            "42815"
#define SQL_INV_USE_DATATIME_OR_DUR         "42816"
#define SQL_OPERANDS_NOT_COMPATIBLE         "42818"
#define SQL_NUMBER_IS_REQUIRED              "42819"
#define SQL_NUM_CONST_OUT_OF_RANGE          "42820"
#define SQL_VALUE_INCOMPAT_WITH_COLUMN      "42821"
#define SQL_BAD_GROUP_ORDER_BY_EXPR         "42822"
#define SQL_MULT_COLS_IN_SELECT_SUBQ        "42823"
#define SQL_LIKE_OPERAND_INVALID            "42824"
#define SQL_UNION_OPERANDS_COL_INCOMP       "42825"
#define SQL_NUM_COLUMNS_DO_NOT_MATCH        "42826"
#define SQL_TABLE_DIFFERS_FROM_CURSOR       "42827"
#define SQL_TABLE_CANNOT_BE_MODIFIED        "42828"
#define SQL_CANNOT_MODIFY_RESULT_TBL        "42829"
#define SQL_FOREIGNKEY_NOT_LIKE_PARENT      "42830"
#define SQL_NO_NULLS_ALLOWED_IN_KEY         "42831"
#define SQL_AUTH_OPER_SYSOBJ_NOTALLOW       "42832"
#define SQL_NULL_VALUE_NOTALLOW             "42834"
#define SQL_UDF_INVALID_HANDLE_PLACED       "42835"
#define SQL_RECURS_NAME_DERIVE_TBL_INV      "42836"
#define SQL_COL_ATTRIBUTE_INCOMPAT          "42837"
#define SQL_INV_USE_OF_TABLESPACE           "42838"
#define SQL_MUST_USE_SAME_TABLESPACE        "42839"
#define SQL_AS_CAST_USE_ERROR               "42840"
#define SQL_PARM_MARKER_INV_NAME            "42841"
#define SQL_SYNTAX_TYPE_OPT_INV             "42842"
#define SQL_INV_BOOL_IN_SELECT_LIST         "42844"
#define SQL_INV_VARIANT_FUNCTION            "42845"
#define SQL_INV_CAST                        "42846"
#define SQL_STATE_42849                     "42849"
#define SQL_PRIVS_INV_OR_INCONSIST          "42852"
#define SQL_STATE_42853                     "42853"
#define SQL_RES_COL_TYPE_INCOMPAT           "42854"
#define SQL_LOB_ASSIGN_NOT_ALLOWED          "42855"
#define SQL_STATE_42858                     "42858"
#define SQL_STATE_42860                     "42860"
#define SQL_SYNTAX_TYPE_NOTMATCH            "42866"
#define SQL_STATE_42867                     "42867"
#define SQL_STATE_42872                     "42872"
#define SQL_INV_SCHEMA_NAME                 "42875"
#define SQL_CANNOT_QUALIFY_COLUMN           "42877"
#define SQL_SYNTAX_XTERN_NAME_INV           "42878"
#define SQL_SYNTAX_FUNC_SRC_NOTMATCH        "42879"
#define SQL_SYNTAX_CAST_ERROR               "42880"
#define SQL_INVALID_USE_ROW_FUNC            "42881"
#define SQL_NAME_SCHEMA_DIFF                "42882"
#define SQL_NAME_FUNC_SIGNATURE_UNDEF       "42883"
#define SQL_NAME_FUNC_ARGUMENT_UNDEF        "42884"
#define SQL_SYNTAX_PARM_NUM_NOTMATCH        "42885"
#define SQL_STATE_42886                     "42886"
#define SQL_FUNC_INV_IN_CONTEXT             "42887"
#define SQL_TABLE_HAS_NO_PRIMKEY            "42888"
#define SQL_PRIMARY_KEY_ALREADY_EXIST       "42889"
#define SQL_NOT_UNIQUE_CONSTRAINT_COLS      "42890"
#define SQL_DUP_UNIQUE_CONSTRAINT           "42891"
#define SQL_OBJ_DEPENDS_ON_THIS             "42893"
#define SQL_DEFAULT_VALUE_INV               "42894"
#define SQL_SYNTAX_HOSTVAR_TYPE_INCOMP      "42895"
#define SQL_INV_CORRELATION_REF             "42898"
#define SQL_CORRELATION_REF_NOT_ALLOW       "42899"
#define SQL_ERROR_IN_UDF                    "428A0"
#define SQL_NOACCESS_HOSTFILE_VAR_FILE      "428A1"
#define SQL_ACCESS_PART_NULL                "428A2"
#define SQL_EVMON_BAD_PATH_SPECIFIED        "428A3"
#define SQL_EVMON_BAD_OPTION_SPECIFIED      "428A4"
#define SQL_INV_EXCEPTION_TABLE             "428A5"
#define SQL_EXCEP_TBL_SAME_AS_CHK_TBL       "428A6"
#define SQL_NUM_CHECK_TBLS_MISMATCH         "428A7"
#define SQL_PARENT_TBL_IN_CHCK_PEND_ST      "428A8"
#define SQL_ACCESS_INVALID_RANGE            "428A9"
#define SQL_STATE_428AA                     "428AA"
#define SQL_ILLEGAL_ELMNT_NSTNG             "428B0"
#define SQL_INCORRECT_NUM_ON_NODES          "428B1"
#define SQL_CONTNR_PATH_NM_NOT_VALID        "428B2"
#define SQL_INV_SQLSTATE_FROM_APP           "428B3"
#define SQL_STATE_428B7                     "428B7"
#define SQL_DROP_ONLY_NODE                  "428C0"
#define SQL_IDENTITY_ONLY_ONE               "428C1"
#define SQL_CREATE_MISSING_CLAUSE           "428C2"
#define SQL_NUM_ELEMENTS_NO_MATCH           "428C4"
#define SQL_DATATYPE_MAPPING_NOT_FOUND      "428C5"
#define SQL_IDENTITY_NO_INSERT              "428C9"
#define SQL_TABLE_CLUSTERING_INDEX          "428CA"
#define SQL_TABLESPACE_BUFFPOOL_MATCH       "428CB"
#define SQL_DATALINK_FILE_NO_ACCESS         "428D1"
#define SQL_STATE_428D4                     "428D4"
#define SQL_STATE_428D5                     "428D5"
#define SQL_STATE_428D6                     "428D6"
#define SQL_STATE_428D7                     "428D7"
#define SQL_STATE_428D8                     "428D8"
#define SQL_INVALID_SUPER_OBJECT            "428DB"
#define SQL_TRANSFORM_FUNCTION_INV          "428DC"
#define SQL_TRANSFORM_NOT_DEFINED           "428DD"
#define SQL_PAGESIZE_NOT_SUPPORTED          "428DE"
#define SQL_CREATE_CAST_TYPE_INVALID        "428DF"
#define SQL_CREATE_CAST_FUNC_INVALID        "428DG"
#define SQL_TYPED_TABLE_OP_INVALID          "428DH"
#define SQL_INHERIT_COL_NO_DROP             "428DJ"
#define SQL_COLUMN_SCOPE_DEFINED            "428DK"
#define SQL_FUNC_PARM_SCOPE_DEFINED         "428DL"
#define SQL_TABLE_SCOPE_INVALID             "428DM"
#define SQL_RETURNS_SCOPE_NOT_SPEC          "428DN"
#define SQL_NOT_STRUCTURED_TYPE             "428DP"
#define SQL_SUBTABLE_DIFF_SCHEMA            "428DQ"
#define SQL_SUBTABLE_OP_NO_APPLY            "428DR"
#define SQL_CANNOT_DEF_SUBTABLE_INDEX       "428DS"
#define SQL_OPERAND_INVALID_TYPE            "428DT"
#define SQL_TYPE_NOT_INCLUDED               "428DU"
#define SQL_INVALID_DEF_OPERAND             "428DV"
#define SQL_CANNOT_REF_OBJECT_COL           "428DW"
#define SQL_OBJECT_COL_REQ_ROOT             "428DX"
#define SQL_NO_UPDATE_SUBTABLE_STATS        "428DY"
#define SQL_OBJECT_COLUMN_NO_UPDATE         "428DZ"
#define SQL_INDEX_DEF_NO_MATCH              "428E0"
#define SQL_RANGE_FUNC_INCONSISTENT         "428E1"
#define SQL_NUM_KEY_PARMS_MISMATCH          "428E2"
#define SQL_INDEX_FUNC_ARG_INVALID          "428E3"
#define SQL_FUNC_NOT_SUPP_CRTINDEX          "428E4"
#define SQL_STATE_428E5                     "428E5"
#define SQL_SEARCH_ARG_MISMATCH             "428E6"
#define SQL_USER_DEF_PRED_MISMATCH          "428E7"
#define SQL_SEARCH_TARGET_MISMATCH          "428E8"
#define SQL_ARG_PARM_NO_BOTH                "428E9"
#define SQL_INV_FULLSEL_TYPED_VIEW          "428EA"
#define SQL_COLUMN_NO_READ_ONLY             "428EB"
#define SQL_SUMM_TABLE_FULLSELECT_INV       "428EC"
#define SQL_STRUCT_TYPE_CANNOT_CONST        "428ED"
#define SQL_STATE_428EE                     "428EE"
#define SQL_STATE_428EF                     "428EF"
#define SQL_STATE_428EG                     "428EG"
#define SQL_STATE_428EH                     "428EH"
#define SQL_STATE_428EJ                     "428EJ"
#define SQL_STATE_428EK                     "428EK"
#define SQL_STATE_428EL                     "428EL"
#define SQL_STATE_428EM                     "428EM"
#define SQL_STATE_428EN                     "428EN"
#define SQL_STATE_428EP                     "428EP"
#define SQL_STATE_428EQ                     "428EQ"
#define SQL_STATE_428ER                     "428ER"
#define SQL_STATE_428ES                     "428ES"
#define SQL_STATE_428EU                     "428EU"
#define SQL_STATE_428EV                     "428EV"
#define SQL_STATE_428EW                     "428EW"
#define SQL_STATE_428EX                     "428EX"
#define SQL_STATE_428EY                     "428EY"
#define SQL_STATE_428EZ                     "428EZ"
#define SQL_STATE_428F0                     "428F0"
#define SQL_STATE_428F1                     "428F1"
#define SQL_STATE_428F2                     "428F2"
#define SQL_STATE_428F3                     "428F3"
#define SQL_STATE_428F4                     "428F4"
#define SQL_STATE_428F5                     "428F5"
#define SQL_STATE_428F6                     "428F6"
#define SQL_STATE_428F7                     "428F7"
#define SQL_STATE_428F9                     "428F9"
#define SQL_STATE_428FA                     "428FA"
#define SQL_STATE_428FB                     "428FB"
#define SQL_STATE_428FC                     "428FC"
#define SQL_STATE_428FD                     "428FD"
#define SQL_STATE_428FE                     "428FE"
#define SQL_STATE_428FF                     "428FF"
#define SQL_STATE_428FG                     "428FG"
#define SQL_STATE_428FH                     "428FH"
#define SQL_STATE_428FI                     "428FI"
#define SQL_STATE_428FJ                     "428FJ"
#define SQL_STATE_428FL                     "428FL"
#define SQL_STATE_428FM                     "428FM"
#define SQL_STATE_428FP                     "428FP"
#define SQL_STATE_428FQ                     "428FQ"
#define SQL_STATE_428FR                     "428FR"
#define SQL_TABLE_INCOMPATIBLE              "428FT"
#define SQL_STATE_428FU                     "428FU"
#define SQL_STATE_428FV                     "428FV"
#define SQL_STATE_428FZ                     "428FZ"
#define SQL_TOO_MANY_DATAPARTS              "428G1"
#define SQL_DETACH_LAST_DATAPART            "428G2"
#define SQL_STATE_428G3                     "428G3"
#define SQL_STATE_428G4                     "428G4"
#define SQL_STATE_428G5                     "428G5"
#define SQL_STATE_428G6                     "428G6"
#define SQL_STATE_428G8                     "428G8"
#define SQL_STATE_428G9                     "428G9"
#define SQL_STATE_428GA                     "428GA"
#define SQL_STATE_428GJ                     "428GJ"
#define SQL_DATAPART_MDC_RESTRICT           "428GD"
#define SQL_CANNOT_ATTACH_TABLE             "428GE"
#define SQL_STATE_428GF                     "428GF"
#define SQL_STATE_428GG                     "428GG"
#define SQL_STATE_428GI                     "428GI"
#define SQL_STATE_428GL                     "428GL"
#define SQL_STATE_428GM                     "428GM"
#define SQL_STATE_428GN                     "428GN"
#define SQL_STATE_428GO                     "428GO"
#define SQL_STATE_428GP                     "428GP"
#define SQL_STATE_428GR                     "428GR"
#define SQL_STATE_428GQ                     "428GQ"
#define SQL_STATE_428GS                     "428GS"
#define SQL_STATE_428GT                     "428GT"
#define SQL_STATE_428GU                     "428GU"
#define SQL_STATE_428GV                     "428GV"
#define SQL_STATE_428GW                     "428GW"
#define SQL_STATE_428GX                     "428GX"
#define SQL_STATE_428GZ                     "428GZ"
#define SQL_STATE_428H0                     "428H0"
#define SQL_STATE_428H1                     "428H1"
#define SQL_STATE_428H2                     "428H2"
#define SQL_STATE_428H3                     "428H3"
#define SQL_STATE_428H4                     "428H4"
#define SQL_STATE_428H5                     "428H5"
#define SQL_STATE_428H7                     "428H7"
#define SQL_STATE_428H8                     "428H8"
#define SQL_STATE_428H9                     "428H9"
#define SQL_STATE_428HA                     "428HA"
#define SQL_STATE_428HB                     "428HB"
#define SQL_STATE_428HC                     "428HC"
#define SQL_STATE_428HD                     "428HD"
#define SQL_STATE_428HE                     "428HE"
#define SQL_STATE_428HF                     "428HF"
#define SQL_STATE_428HH                     "428HH"
#define SQL_STATE_428HG                     "428HG"
#define SQL_STATE_428HM                     "428HM"
#define SQL_STATE_428HN                     "428HN"
#define SQL_STATE_428HP                     "428HP"
#define SQL_STATE_428HQ                     "428HQ"
#define SQL_STATE_428HR                     "428HR"
#define SQL_STATE_428HS                     "428HS"
#define SQL_STATE_428HT                     "428HT"
#define SQL_STATE_428HU                     "428HU"
#define SQL_STATE_428HV                     "428HV"
#define SQL_STATE_428HW                     "428HW"
#define SQL_STATE_428HX                     "428HX"
#define SQL_STATE_428HY                     "428HY"
#define SQL_STATE_428HZ                     "428HZ"
#define SQL_STATE_428I3                     "428I3"
#define SQL_STATE_428I7                     "428I7"
#define SQL_STATE_428I8                     "428I8"
#define SQL_STATE_428I9                     "428I9"
#define SQL_STATE_428IA                     "428IA"
#define SQL_STATE_428IB                     "428IB"
#define SQL_VIEW_ON_TRANSIENT_ET            "428IE"
#define SQL_STATE_428IF                     "428IF"
#define SQL_STATE_428IG                     "428IG"
#define SQL_COL_FUNC_NEEDS_COL_NAME         "42901"
#define SQL_OBJECT_ALSO_IN_FROM_CLAUSE      "42902"
#define SQL_WHERE_OR_SET_HAS_INV_REF        "42903"
#define SQL_STATE_42904                     "42904"
#define SQL_STRING_IS_TOO_LONG              "42907"
#define SQL_COLUMN_LIST_MISSING             "42908"
#define SQL_STATE_42910                     "42910"
#define SQL_INVALID_DECIMAL_DIVIDE          "42911"
#define SQL_COLUMN_NOT_IN_UPD_CLAUSE        "42912"
#define SQL_UPDATE_OR_DELETE_INVALID        "42913"
#define SQL_TABLE_IN_SUBQUERY_AFFECTED      "42914"
#define SQL_INV_REFERENTIAL_CONSTRAINT      "42915"
#define SQL_REP_CHAIN_ALIAS_INVALID         "42916"
#define SQL_CANNOT_EXPLICITLY_DROP_OBJ      "42917"
#define SQL_NAME_RESERVED                   "42918"
#define SQL_STATE_42919                     "42919"
#define SQL_CANNOT_ADD_CONTAINERS           "42921"
#define SQL_REC_NAME_DER_TLB_SPEC_INV       "42925"
#define SQL_STATE_42928                     "42928"
#define SQL_PROG_ASSUMPTIONS_INCORRECT      "42932"
#define SQL_AUTH_CREATE_SYSOBJ_NOALLOW      "42939"
#define SQL_SERVER_NAME_MISMATCH            "42961"
#define SQL_INV_USE_LONG_COLUMN             "42962"
#define SQL_STATE_42963                     "42963"
#define SQL_NO_SW_LICENSE                   "42968"
#define SQL_PACKAGE_NOT_CREATED             "42969"
#define SQL_INV_JOIN_CONDITION              "42972"
#define SQL_STATE_42985                     "42985"
#define SQL_INV_CONN_RESET                  "42986"
#define SQL_STMT_INV_FOR_STORPROC_TRIG      "42987"
#define SQL_STATE_42989                     "42989"
#define SQL_INDEX_COLS_NOT_SUBSET           "42990"
#define SQL_SYNTAX_SYSTEM_USE_ONLY          "42991"
#define SQL_LOB_COL_TOO_BIG_TO_LOG          "42993"
#define SQL_RAW_DEVICE_NOT_SUPP             "42994"
#define SQL_FUNC_NO_GLOBAL_TEMP             "42995"
#define SQL_UNIQUE_NOT_ALLOWED              "42997"
#define SQL_INV_NODEGROUP                   "429A1"
#define SQL_DATAJOINER_NO_PROCESS           "429A9"
#define SQL_INV_NOTLOGINIT                  "429AA"
#define SQL_TYPE_LENGTH_TOO_SMALL           "429B2"
#define SQL_NO_DEF_OBJECT_SUBTBL            "429B3"
#define SQL_FILTER_FUNC_NO_LANG             "429B4"
#define SQL_INSTANCE_PARM_TYPE_INV          "429B5"
#define SQL_STATE_429B8                     "429B8"
#define SQL_STATE_429B9                     "429B9"
#define SQL_STATE_429BA                     "429BA"
#define SQL_STATE_429BB                     "429BB"
#define SQL_STATE_429BC                     "429BC"
#define SQL_STATE_429BE                     "429BE"
#define SQL_STATE_429BG                     "429BG"
#define SQL_INV_DATAPART_COL_TYPE           "429BH"
#define SQL_STATE_429BJ                     "429BJ"
#define SQL_STATE_429BK                     "429BK"
#define SQL_STATE_429BL                     "429BL"
#define SQL_STATE_429BM                     "429BM"
#define SQL_STATE_429BO                     "429BO"
#define SQL_STATE_429BP                     "429BP"
#define SQL_STATE_429BS                     "429BS"
#define SQL_STATE_429BU                     "429BU"
#define SQL_STATE_429BV                     "429BV"
#define SQL_STATE_429BX                     "429BX"
#define SQL_STATE_429BZ                     "429BZ"
#define SQL_STATE_429C0                     "429C0"
#define SQL_STATE_429C2                     "429C2"
#define SQL_STATE_429C3                     "429C3"
#define SQL_STATE_429C4                     "429C4"
#define SQL_STATE_429C5                     "429C5"
#define SQL_STATE_429C8                     "429C8"
#define SQL_STATE_429C9                     "429C9"
#define SQL_STATE_429CA                     "429CA"
#define SQL_STATE_429CC                     "429CC"
#define SQL_STATE_429DB                     "429DB"
#define SQL_VIEW_DEF_NOT_SATISFIED          "44000"
#define SQL_STATE_45000                     "45000"
#define SQL_STATE_46001                     "46001"
#define SQL_STATE_46002                     "46002"
#define SQL_STATE_46003                     "46003"
#define SQL_STATE_46007                     "46007"
#define SQL_STATE_46008                     "46008"
#define SQL_STATE_46103                     "46103"
#define SQL_STATE_46501                     "46501"
#define SQL_STATE_46503                     "46503"
#define SQL_STATE_CALL_INV                  "51001"
#define SQL_STATE_PACKAGE_NOTFOUND          "51002"
#define SQL_STATE_TOKENS_NOTMATCH           "51003"
#define SQL_STATE_ADDR_INV_DA               "51004"
#define SQL_STATE_FUNC_DISABLED             "51005"
#define SQL_STATE_STMT_NOTEXEC              "51007"
#define SQL_STATE_RELEASE_INV               "51008"
#define SQL_STATE_PROC_NOTCONNECTABLE       "51011"
#define SQL_STATE_SECTION_BINDERR           "51015"
#define SQL_STATE_USER_NOTLOGGEDON          "51017"
#define SQL_STATE_APP_UNCONNECTED           "51018"
#define SQL_STATE_CRTPACK_BUSY              "51019" /* Planned                */
#define SQL_STATE_PACK_NONE                 "51020" /* Planned                */
#define SQL_ROLLBACK_REQUIRED               "51021"
#define SQL_CONN_WITH_AUTH_ALREADY          "51022"
#define SQL_STATE_DB_INUSE_ANOTH_INST       "51023"
#define SQL_INOPERAITVE_VIEW                "51024"
#define SQL_CONN_SETTINGS_IN_USE            "51025"
#define SQL_EVMON_PATH_INUSE                "51026"
#define SQL_IMMEDIATE_CHECKED_OPT_INV       "51027"
#define SQL_PACKAGE_INOPERATIVE             "51028"
#define SQL_STATE_51030                     "51030"
#define SQL_STATE_51034                     "51034"
#define SQL_STATE_51035                     "51035"
#define SQL_STATE_51038                     "51038"
#define SQL_STATE_51039                     "51039"
#define SQL_STATE_51040                     "51040"
#define SQL_STATE_51041                     "51041"
#define SQL_STATE_51042                     "51042"
#define SQL_STATE_51044                     "51044"
#define SQL_STATE_51046                     "51046"
#define SQL_STATE_530AC                     "530AC"
#define SQL_STATE_530AD                     "530AD"
#define SQL_STATE_530AE                     "530AE"
#define SQL_STATE_530AF                     "530AF"
#define SQL_STATE_54059                     "54059"
#define SQL_NAME_COL_DUP_STMT               "52001"
#define SQL_NAME_COLREF_DUP_NAME            "52002"
#define SQL_NAME_COL_UNDEF                  "52003"
#define SQL_NAME_OBJ_UNDEF                  "52004"
#define SQL_NAME_SERVER_UNDEF               "52005"
#define SQL_NAME_COL_INV                    "52006"
#define SQL_NAME_COL_NOTRESULT              "52007"
#define SQL_NAME_CURSOR_UNDEF               "52008"
#define SQL_NAME_COL_DUP_KEYCLAUSE          "52009"
#define SQL_NAME_OBJ_DUP                    "52010"
#define SQL_NAME_COL_DUP_OBJDEF             "52011"
#define SQL_NAME_TABLE_DUP                  "52012"
#define SQL_NAME_CURSOR_DUP                 "52013" /* Planned                */
#define SQL_NAME_CURSOR_NOTQUAL             "52015" /* Planned                */
#define SQL_NAME_COLREF_DUP_SET             "52016" /* Planned                */
#define SQL_NAME_AS_NONAME                  "52017"
#define SQL_NAME_CURSOR_UNDECL              "52019" /* Planned                */
#define SQL_NAME_NODE_NOTFOUND              "52020"
#define SQL_NAME_REG_UNKNOWN                "52021" /* Planned                */
#define SQL_STATE_54061                     "54061"
#define SQL_STATE_54062                     "54062"
#define SQL_STATE_54064                     "54064"
#define SQL_STATE_54066                     "54066"
#define SQL_STATE_55019                     "55019"
#define SQL_STATE_55064                     "55064"
#define SQL_STATE_55065                     "55065"
#define SQL_STATE_55066                     "55066"
#define SQL_STATE_55067                     "55067"
#define SQL_STATE_55068                     "55068"
#define SQL_STATE_55070                     "55070"
#define SQL_STATE_55071                     "55071"
#define SQL_STATE_55072                     "55072"
#define SQL_STATE_55074                     "55074"
#define SQL_STATE_55075                     "55075"
#define SQL_STATE_55077                     "55077"
#define SQL_STATE_5507B                     "5507B"
#define SQL_STATE_560D2                     "560D2"
#define SQL_STATE_560D4                     "560D4"
#define SQL_STATE_560D6                     "560D6"
#define SQL_STATE_560D7                     "560D7"
#define SQL_STATE_560D9                     "560D9"
#define SQL_STATE_560DA                     "560DA"
#define SQL_STATE_560DB                     "560DB"
#define SQL_STATE_58041                     "58041"
#define SQL_STATE_5U001                     "5U001"
#define SQL_STATE_5U002                     "5U002"
#define SQL_STATE_5U003                     "5U003"
#define SQL_STATE_5U004                     "5U004"
#define SQL_STATE_5U005                     "5U005"
#define SQL_STATE_5U006                     "5U006"
#define SQL_STATE_5U009                     "5U009"
#define SQL_STATE_5U010                     "5U010"
#define SQL_STATE_5U011                     "5U011"
#define SQL_STATE_5U012                     "5U012"
#define SQL_STATE_5U013                     "5U013"
#define SQL_STATE_5U014                     "5U014"
#define SQL_STATE_5U015                     "5U015"
#define SQL_STATE_5U016                     "5U016"
#define SQL_STATE_5U017                     "5U017"
#define SQL_STATE_5U018                     "5U018"
#define SQL_STATE_5U019                     "5U019"
#define SQL_STATE_5U020                     "5U020"
#define SQL_STATE_5U021                     "5U021"
#define SQL_STATE_5U022                     "5U022"
#define SQL_STATE_5U023                     "5U023"
#define SQL_STATE_5U024                     "5U024"
#define SQL_STATE_5U025                     "5U025"
#define SQL_STATE_5U026                     "5U026"
#define SQL_STATE_5U027                     "5U027"
#define SQL_STATE_5U028                     "5U028"
#define SQL_STATE_5U029                     "5U029"
#define SQL_STATE_5U030                     "5U030"
#define SQL_STATE_5U031                     "5U031"
#define SQL_STATE_5U032                     "5U032"
#define SQL_STATE_5U033                     "5U033"
#define SQL_STATE_5U034                     "5U034"
#define SQL_STATE_5U035                     "5U035"
#define SQL_STATE_5U036                     "5U036"
#define SQL_STATE_5U037                     "5U037"
#define SQL_STATE_5U038                     "5U038"
#define SQL_STATE_5U039                     "5U039"
#define SQL_STATE_5U040                     "5U040"
#define SQL_STATE_5U041                     "5U041"
#define SQL_STATE_5U042                     "5U042"
#define SQL_STATE_5U043                     "5U043"
#define SQL_STATE_5U044                     "5U044"
#define SQL_STATE_5U047                     "5U047"
#define SQL_STATE_5U048                     "5U048"
#define SQL_STATE_5U055                     "5U055"
#define SQL_STATE_5U056                     "5U056"
#define SQL_STATE_5U057                     "5U057"
#define SQL_STATE_5U0ZZ                     "5U0ZZ"
#define SQL_STATE_5UA02                     "5UA02"
#define SQL_STATE_5UA0O                     "5UA0O"
#define SQL_STATE_ORANF                     "ORANF"
#define SQL_STATE_ZZZZZ                     "ZZZZZ"
#define SQL_OPSPEC_NUMVAL_NOTSAME           "53002"
#define SQL_OPSPEC_COLUMN_INV               "53003"
#define SQL_OPSPEC_CLAUSE_NOTCOLUMN         "53005"
#define SQL_OPSPEC_OP_NOTPERMIT             "53007"
#define SQL_OPSPEC_COL_NOTUPDATABLE         "53008"
#define SQL_OPSPEC_OBJ_WRONGTYPE            "53009"
#define SQL_OPSPEC_CLAUSE_ISVIEW            "53010"
#define SQL_OPSPEC_NUMCOL_NOTSAME           "53011"
#define SQL_OPSPEC_OPTION_BAD               "53013"
#define SQL_OPSPEC_DATA_INV                 "53015"
#define SQL_OPSPEC_DATETIME_INV_EXPR        "53016"
#define SQL_OPSPEC_NUMVAR_NOTSAME           "53017"
#define SQL_OPSPEC_OPERANDS_NOTCOMPAT       "53018"
#define SQL_OPSPEC_OP_NOTNUMB               "53019"
#define SQL_OPSPEC_CONS_TOOLONG             "53020"
#define SQL_OPSPEC_VAL_NOTCOMPAT_COL        "53021"
#define SQL_OPSPEC_CLAUSE_TOOMANY           "53023"
#define SQL_OPSPEC_LIKEOP_BAD               "53024"
#define SQL_OPSPEC_UNIONOP_INCOMPAT_COL     "53025"
#define SQL_OPSPEC_UNIONOP_BADNUM_COL       "53026"
#define SQL_OPSPEC_TABLE_NOTSAME_CURSOR     "53027"
#define SQL_OPSPEC_TABLE_CANTMODIFY         "53028"
#define SQL_OPSPEC_UPDATE_INV_ROTABLE       "53029"
#define SQL_OPSPEC_FKEY_NOTCONFORM          "53030"
#define SQL_OPSPEC_NULL_NOTALLOW            "53031"
#define SQL_OPSPEC_OP_NOTALLOW_SYSOBJ       "53032"
#define SQL_OPSPEC_FKEY_NOTALLOW_NULL       "53034"
#define SQL_WRONG_NUMBER_PART_COLS          "53038"
#define SQL_STATE_53040                     "53040"
#define SQL_OPSPEC_COL_INV                  "53042"
#define SQL_DATAPART_INV_KEY_VALUE          "53045"
#define SQL_OPSPEC_PRIV_INV                 "53052"
#define SQL_OPSPEC_OPT_BOTH                 "53053" /* Planned                */
#define SQL_OPSPEC_AUTH_BAD                 "53056"
#define SQL_OPSPEC_STMT_CANTUSE             "53059" /* Planned                */
#define SQL_OPSPEC_DB_CANTUSE               "53061"
#define SQL_OPSPEC_STMT_CANTEXEC            "53062" /* Planned                */
#define SQL_OPSPEC_HOSTVAR_UNDEF            "53063"
#define SQL_OPSPEC_INFO_NOTMATCH            "53064" /* Planned                */
#define SQL_OPSPEC_OPTIONS_CONFLICT         "53067" /* Planned                */
#define SQL_OPSPEC_DESCRIPTORS_TOOFEW       "53070" /* Planned                */
#define SQL_OPSPEC_NUMSTRUCTS_NOTMATCH      "53071" /* Planned                */
#define SQL_OPSPEC_CLAUSE_INCOMPAT          "53072" /* Planned                */
#define SQL_OPSPEC_NUMROWS_INV              "53073" /* Planned                */
#define SQL_STATE_53090                     "53090"
#define SQL_STATE_53091                     "53091"
#define SQL_STATE_530AA                     "530AA"
#define SQL_STATE_530AB                     "530AB"
#define SQL_LIMIT_STMT_TOOLONG              "54001"
#define SQL_LIMIT_SCONST_TOOLONG            "54002"
#define SQL_LIMIT_NAME_TOOLONG              "54003"
#define SQL_LIMIT_NAMES_TOOMANY             "54004"
#define SQL_LIMIT_CONCAT_TOOLONG            "54006"
#define SQL_LIMIT_AS_TOOBIG                 "54007" /* Planned                */
#define SQL_LIMIT_KEY_TOOLONG               "54008"
#define SQL_LIMIT_TABLE_TOOLONG             "54010"
#define SQL_LIMIT_COLS_TOOMANY              "54011"
#define SQL_LIMIT_DESCRIPTORS_TOOMANY       "54019"
#define SQL_LIMIT_ARGUMENTS_TOOMANY         "54023"
#define SQL_LIMIT_CONCUR_LOB_HANDLES        "54028"
#define SQL_LIMIT_OPEN_DIR_SCANS            "54029"
#define SQL_LIMIT_EVMON_TOOMANY             "54030"
#define SQL_LIMIT_EVTFILES_TOOMANY          "54031"
#define SQL_LIMIT_MAX_TABLE_SIZE            "54032"
#define SQL_LIMIT_PMAP_TOOMANY              "54033"
#define SQL_LIMIT_CONTNR_NAMES_LEN          "54034"
#define SQL_LIMIT_TBLSPACE_SIZE             "54035"
#define SQL_LIMIT_CONTNR_PATH_LEN           "54036"
#define SQL_LIMIT_CONTAIN_MAP_COMPLX        "54037"
#define SQL_LIMIT_CASCADED_TRIGGERS         "54038"
#define SQL_LIMIT_CONTAINER_SIZE            "54039"
#define SQL_LIMIT_TRANSITION_TBL            "54040"
#define SQL_LIMIT_TYPE_LEVEL                "54045"
#define SQL_LIMIT_MAX_PARM_INDEX            "54046"
#define SQL_LIMIT_MAX_TSPACE_SIZE           "54047"
#define SQL_NO_TEMP_TSPACE_PAGE_SIZE        "54048"
#define SQL_STATE_54049                     "54049"
#define SQL_STATE_54050                     "54050"
#define SQL_STATE_54052                     "54052"
#define SQL_STATE_54053                     "54053"
#define SQL_LIMIT_PARTS_TOOMANY             "54054"
#define SQL_STATE_54057                     "54057"
#define SQL_STATE_54058                     "54058"
#define SQL_STATE_54063                     "54063"
#define SQL_STATE_54067                     "54067"
#define SQL_STATE_DB_NOTMIGR                "55001"
#define SQL_STATE_EXPL_TBL_NOT_DEFINED      "55002"
#define SQL_STATE_OBJ_INUSE                 "55006"
#define SQL_STATE_OBJ_NOTALTER              "55007"
#define SQL_STATE_TABLE_NOKEY               "55008"
#define SQL_STATE_FILE_READONLY             "55009"
#define SQL_STATE_OBJ_HASDEPS               "55010" /* Planned                */
#define SQL_STATE_TABLE_HASCLUSTIDX         "55012"
#define SQL_STATE_TABLE_HASKEY              "55013"
#define SQL_STATE_TABLE_INVALID             "55019"
#define SQL_SERVER_NOT_REGISTERED           "55022"
#define SQL_STATE_55023                     "55023"
#define SQL_CHK_CONSTRAINT_TOO_LONG         "55024"
#define SQL_STATE_DB_NEEDRESTART            "55025"
#define SQL_TRIGGER_DEF_TOO_LONG            "55026"
#define SQL_STATE_OS2_RESERVED              "55031" /* Planned                */
#define SQL_CONN_INV_DBM_STOPPED            "55032" /* Planned                */
#define SQL_MUST_COMMIT_FOR_EVMON           "55033"
#define SQL_EVMON_ACTIVE_CANT_DROP          "55034"
#define SQL_STATE_55035                     "55035"
#define SQL_STATE_DROP_PART_KEY             "55037"
#define SQL_STATE_REBALANCING               "55038"
#define SQL_INV_STATE_CHANGE                "55039"
#define SQL_STATE_55040                     "55040"
#define SQL_REBALANCE_IN_PROGRESS           "55041"
#define SQL_TYPED_TABLE_EXISTS              "55043"
#define SQL_STATE_55045                     "55045"
#define SQL_STATE_55046                     "55046"
#define SQL_STATE_55047                     "55047"
#define SQL_STATE_55048                     "55048"
#define SQL_STATE_55049                     "55049"
#define SQL_STATE_55051                     "55051"
#define SQL_STATE_55054                     "55054"
#define SQL_STATE_55056                     "55056"
#define SQL_STATE_56023                     "56023"
#define SQL_MISC_INC_MAINT_REQD             "55057"
#define SQL_NO_AUTOMATIC_STORAGE            "55060"
#define SQL_NO_REDIRECTED_RESTORE           "55061"
#define SQL_STORAGE_PATHS_NOT_ALLOWED       "55062"
#define SQL_STATE_55063                     "55063"
#define SQL_STATE_55073                     "55073"
#define SQL_STATE_DPF_XML_FED_FAILED        "55076"
#define SQL_MISC_NONAME                     "56001"
#define SQL_MISC_FROM_INV                   "56002"
#define SQL_MISC_WHERE_INV                  "56003"
#define SQL_MISC_DISTINCT_TOOMANY           "56005"
#define SQL_MISC_STR_TOOLONG                "56007"
#define SQL_MISC_LIST_MISSING               "56008"
#define SQL_STATE_55069                     "55069"
#define SQL_MISC_DIVIDE_NEG                 "56011"
#define SQL_MISC_COL_NOUPDATE               "56012"
#define SQL_MISC_UPDDEL_INV                 "56013"
#define SQL_MISC_DEL_INV                    "56014"
#define SQL_MISC_CONSTR_INV                 "56015"
#define SQL_MISC_INV_DATAPART_RANGE         "56016"
#define SQL_MISC_OBJECT_NODROP              "56017"
#define SQL_MISC_INV_COMM_ROLL              "56021"
#define SQL_MISC_REF_INV                    "56023" /* Planned                */
#define SQL_MISC_ALIAS_NOTTABLE             "56024" /* Planned                */
#define SQL_MISC_OP_INV                     "56026"
#define SQL_MISC_MIXED_DBCS_INV             "56031"
#define SQL_MISC_PREP_INV                   "56032"
#define SQL_MISC_STRING_HOSTVAR             "56033"
#define SQL_STATE_56038                     "56038"
#define SQL_MISC_OBJ_NOTCRT                 "56039"
#define SQL_MISC_PACKAGE_NOTCOMMIT          "56043" /* Planned                */
#define SQL_MISC_NAME_NOTID                 "56052" /* Planned                */
#define SQL_MISC_DATA_NOTSUPP               "56059" /* Planned                */
#define SQL_MISC_STMT_NOTEXEC               "56060" /* Planned                */
#define SQL_MISC_NAME_NOTMATCH              "56061"
#define SQL_MISC_ISO_NOTUSER                "56068"
#define SQL_MISC_JOIN_BADCOLS               "56072" /* Planned                */
#define SQL_MISC_NAME_REQUIRED              "56073" /* Planned                */
#define SQL_MISC_NAME_NOTQUAL               "56074" /* Planned                */
#define SQL_LOB_NOSUPP_IN_DRDA              "56084"
#define SQL_MISC_N_A_COMPOUND_SQL_ERR       "56091"
#define SQL_MISC_NAME_BOTH_USER_GROUP       "56092"
#define SQL_MISC_NO_BLOB_IN_DWNLVL_CL       "56093"
#define SQL_STATE_56090                     "56090"
#define SQL_STATE_56095                     "56095"
#define SQL_MISC_NOT_ALIGNED                "56097"
#define SQL_MISC_PREP_REBIND_INV            "56098"
#define SQL_MISC_REAL_NOT_SUPPORTED         "56099"
#define SQL_MISC_LOB_ACTION_FAILED          "560A0"
#define SQL_FUNC_CLAUSE_INVALID_UCS2        "560AA"
#define SQL_STATE_560AC                     "560AC"
#define SQL_STATE_560AE                     "560AE"
#define SQL_STATE_560AF                     "560AF"
#define SQL_STATE_560B0                     "560B0"
#define SQL_STATE_560B1                     "560B1"
#define SQL_STATE_560B7                     "560B7"
#define SQL_STATE_560BB                     "560BB"
#define SQL_STATE_560BC                     "560BC"
#define SQL_STATE_560BD                     "560BD"
#define SQL_STATE_560BF                     "560BF"
#define SQL_STATE_560C0                     "560C0"
#define SQL_STATE_560C1                     "560C1"
#define SQL_STATE_560C2                     "560C2"
#define SQL_STATE_560C3                     "560C3"
#define SQL_STATE_560C6                     "560C6"
#define SQL_STATE_560C8                     "560C8"
#define SQL_STATE_560C9                     "560C9"
#define SQL_STATE_560CA                     "560CA"
#define SQL_STATE_560CB                     "560CB"
#define SQL_STATE_560CD                     "560CD"
#define SQL_STATE_560CE                     "560CE"
#define SQL_STATE_560CF                     "560CF"
#define SQL_STATE_560CG                     "560CG"
#define SQL_STATE_560CH                     "560CH"
#define SQL_STATE_560CI                     "560CI"
#define SQL_STATE_560CJ                     "560CJ"
#define SQL_STATE_560CL                     "560CL"
#define SQL_STATE_560CN                     "560CN"
#define SQL_STATE_560CO                     "560CO"
#define SQL_STATE_560CP                     "560CP"
#define SQL_STATE_560CS                     "560CS"
#define SQL_STATE_560CT                     "560CT"
#define SQL_STATE_560CW                     "560CW"
#define SQL_STATE_560CZ                     "560CZ"
#define SQL_STATE_560D0                     "560D0"
#define SQL_STATE_560DF                     "560DF"
#define SQL_STATE_57007                     "57007"
#define SQL_STATE_57011                     "57011"
#define SQL_STATE_57014                     "57014"
#define SQL_STATE_57053                     "57053"
#define SQL_STATE_57059                     "57059"
#define SQL_STATE_57060                     "57060"
#define SQL_STATE_57061                     "57061"
#define SQL_STATE_57062                     "57062"
#define SQL_STATE_57063                     "57063"
#define SQL_STATE_57066                     "57066"
#define SQL_STATE_57067                     "57067"
#define SQL_STATE_5507A                     "5507A"
#define SQL_STATE_57065                     "57065"
#define SQL_STATE_58024                     "58024"
#define SQL_STATE_58038                     "58038"
#define SQL_STATE_58039                     "58039"
#define SQL_STATE_5UA01                     "5UA01"
#define SQL_STATE_5UA03                     "5UA03"
#define SQL_STATE_5UA04                     "5UA04"
#define SQL_STATE_5UA05                     "5UA05"
#define SQL_STATE_5UA06                     "5UA06"
#define SQL_STATE_5UA07                     "5UA07"
#define SQL_STATE_5UA08                     "5UA08"
#define SQL_STATE_5UA09                     "5UA09"
#define SQL_STATE_5UA0A                     "5UA0A"
#define SQL_STATE_5UA0B                     "5UA0B"
#define SQL_STATE_5UA0C                     "5UA0C"
#define SQL_STATE_5UA0D                     "5UA0D"
#define SQL_STATE_5UA0E                     "5UA0E"
#define SQL_STATE_5UA0F                     "5UA0F"
#define SQL_STATE_5UA0G                     "5UA0G"
#define SQL_STATE_5UA0H                     "5UA0H"
#define SQL_STATE_5UA0I                     "5UA0I"
#define SQL_STATE_5UA0J                     "5UA0J"
#define SQL_STATE_5UA0K                     "5UA0K"
#define SQL_STATE_5UA0L                     "5UA0L"
#define SQL_STATE_5UA0M                     "5UA0M"
#define SQL_STATE_5UA0N                     "5UA0N"
#define SQL_STATE_5UA0P                     "5UA0P"
#define SQL_STATE_5UA0Q                     "5UA0Q"
#define SQL_STATE_54068                     "54068"
#define SQL_STATE_57068                     "57068"
#define SQL_STATE_58040                     "58040"
#define SQL_STATE_5U060                     "5U060"
#define SQL_STATE_5U061                     "5U061"
#define SQL_RESOURCE_TABLE_UNAVAILABLE      "57001"
#define SQL_RESOURCE_BUFFPOOL_INACTIVE      "57003"
#define SQL_RESOURCE_PENDING                "57007"
#define SQL_RESOURCE_VSDB_TUNAVAIL          "57009"
#define SQL_RESOURCE_VSDB_UNAVAIL           "57011"
#define SQL_RESOURCE_NONDB_UNAVAIL_CONT     "57012"
#define SQL_RESOURCE_NONDB_UNAVAIL_STOP     "57013"
#define SQL_RESOURCE_CANCEL                 "57014"
#define SQL_RESOURCE_TABLE_INACTIVE         "57016"
#define SQL_RESOURCE_CXLATE_NOTDEF          "57017"
#define SQL_RESOURCE_DRIVE_NOTEXIST         "57019"
#define SQL_RESOURCE_DRIVE_LOCKED           "57020"
#define SQL_RESOURCE_DRIVE_OPEN             "57021"
#define SQL_RESOURCE_NO_DBSPACES            "57022"
#define SQL_RESOURCE_MAXAPPS                "57030"
#define SQL_RESOURCE_MAXDB                  "57032"
#define SQL_RESOURCE_DB_STARTED             "57033"
#define SQL_RESOURCE_DB_ACQUIRED            "57034"
#define SQL_RESOURCE_DBFILE_NOTOWN          "57035"
#define SQL_RESOURCE_LOG_NOTOWN             "57036"
#define SQL_RESOURCE_STANDALONE             "57041"
#define SQL_RESOURCE_QUIESCE_BACKUP         "57046"
#define SQL_RESOURCE_DIR_NOT_ACCESS         "57047"
#define SQL_RESOURCE_CONTNR_ACC_ERR         "57048"
#define SQL_RESOURCE_SYS_LIMIT              "57049"
#define SQL_RESOURCE_PATH                   "57050"
#define SQL_RESOURCE_CPU_COST               "57051"
#define SQL_RESOURCE_UNAVAIL_NODE           "57052"
#define SQL_RESOURCE_TABSPACE_SIZE          "57055"
#define SQL_RESOURCE_NO_PACKAGE_LOCK        "57056"
#define SQL_RESOURCE_DRDA_CHAIN_COND        "57057"
#define SQL_RESOURCE_DISK_STUFFIT           "57901"
#define SQL_RESOURCE_DISK_BAD               "57902"
#define SQL_RESOURCE_DISK_FULL              "57903"
#define SQL_SYSERR_INV_SECT                 "58003"
#define SQL_SYSERR_ERR_CONT                 "58004"
#define SQL_SYSERR_ERR_STOP                 "58005"
#define SQL_SYSERR_DIST_CONT                "58008"
#define SQL_SYSERR_DIST_DEALLOC             "58009"
#define SQL_SYSERR_DIST_STOP                "58010"
#define SQL_SYSERR_BIND_ACTIVE              "58011"
#define SQL_SYSERR_BIND_INACTIVE            "58012"
#define SQL_SYSERR_CMD_NOTSUPP              "58014"
#define SQL_SYSERR_OBJ_NOTSUPP              "58015"
#define SQL_SYSERR_PARAM_NOTSUPP            "58016"
#define SQL_SYSERR_VALUE_NOTSUPP            "58017"
#define SQL_SYSERR_MSG_NOTSUPP              "58018"
#define SQL_SYSERR_COMMERR                  "58019"
#define SQL_SYSERR_NOTDEF                   "58020"
#define SQL_SYSERR_PROG_CANCELED            "58023"
#define SQL_SYSERR_HOSTVARS                 "58026" /* Planned                */
#define SQL_SYSERR_IOERR                    "58030"
#define SQL_SYSERR_DBFILE                   "58031"
#define SQL_SYSERR_STR_FENCED_FUN_FAIL      "58032"
#define SQL_SYSERR_FIND_TBSP_PG_FAIL        "58034"
#define SQL_SYSERR_FREE_TBSP_PG_FAIL        "58035"
#define SQL_SYSERR_TBLSPC_ID_NOEXIST        "58036"

#ifdef __cplusplus 
}
#endif

#endif /* SQL_H_SQLSTATE */
